// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// Settings for Azure Files identity based authentication.
/// </summary>
public partial class FilesIdentityBasedAuthentication : ProvisionableConstruct
{
    /// <summary>
    /// Indicates the directory service used. Note that this enum may be
    /// extended in the future.
    /// </summary>
    public BicepValue<DirectoryServiceOption> DirectoryServiceOptions 
    {
        get { Initialize(); return _directoryServiceOptions!; }
        set { Initialize(); _directoryServiceOptions!.Assign(value); }
    }
    private BicepValue<DirectoryServiceOption>? _directoryServiceOptions;

    /// <summary>
    /// Required if directoryServiceOptions are AD, optional if they are
    /// AADKERB.
    /// </summary>
    public StorageActiveDirectoryProperties ActiveDirectoryProperties 
    {
        get { Initialize(); return _activeDirectoryProperties!; }
        set { Initialize(); AssignOrReplace(ref _activeDirectoryProperties, value); }
    }
    private StorageActiveDirectoryProperties? _activeDirectoryProperties;

    /// <summary>
    /// Default share permission for users using Kerberos authentication if
    /// RBAC role is not assigned.
    /// </summary>
    public BicepValue<DefaultSharePermission> DefaultSharePermission 
    {
        get { Initialize(); return _defaultSharePermission!; }
        set { Initialize(); _defaultSharePermission!.Assign(value); }
    }
    private BicepValue<DefaultSharePermission>? _defaultSharePermission;

    /// <summary>
    /// Creates a new FilesIdentityBasedAuthentication.
    /// </summary>
    public FilesIdentityBasedAuthentication()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// FilesIdentityBasedAuthentication.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _directoryServiceOptions = DefineProperty<DirectoryServiceOption>("DirectoryServiceOptions", ["directoryServiceOptions"]);
        _activeDirectoryProperties = DefineModelProperty<StorageActiveDirectoryProperties>("ActiveDirectoryProperties", ["activeDirectoryProperties"]);
        _defaultSharePermission = DefineProperty<DefaultSharePermission>("DefaultSharePermission", ["defaultSharePermission"]);
    }
}
