// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// The key vault properties for the encryption scope. This is a required field
/// if encryption scope &apos;source&apos; attribute is set to
/// &apos;Microsoft.KeyVault&apos;.
/// </summary>
public partial class EncryptionScopeKeyVaultProperties : ProvisionableConstruct
{
    /// <summary>
    /// The object identifier for a key vault key object. When applied, the
    /// encryption scope will use the key referenced by the identifier to
    /// enable customer-managed key support on this encryption scope.
    /// </summary>
    public BicepValue<Uri> KeyUri 
    {
        get { Initialize(); return _keyUri!; }
        set { Initialize(); _keyUri!.Assign(value); }
    }
    private BicepValue<Uri>? _keyUri;

    /// <summary>
    /// The object identifier of the current versioned Key Vault Key in use.
    /// </summary>
    public BicepValue<string> CurrentVersionedKeyIdentifier 
    {
        get { Initialize(); return _currentVersionedKeyIdentifier!; }
    }
    private BicepValue<string>? _currentVersionedKeyIdentifier;

    /// <summary>
    /// Timestamp of last rotation of the Key Vault Key.
    /// </summary>
    public BicepValue<DateTimeOffset> LastKeyRotationTimestamp 
    {
        get { Initialize(); return _lastKeyRotationTimestamp!; }
    }
    private BicepValue<DateTimeOffset>? _lastKeyRotationTimestamp;

    /// <summary>
    /// Creates a new EncryptionScopeKeyVaultProperties.
    /// </summary>
    public EncryptionScopeKeyVaultProperties()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// EncryptionScopeKeyVaultProperties.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _keyUri = DefineProperty<Uri>("KeyUri", ["keyUri"]);
        _currentVersionedKeyIdentifier = DefineProperty<string>("CurrentVersionedKeyIdentifier", ["currentVersionedKeyIdentifier"], isOutput: true);
        _lastKeyRotationTimestamp = DefineProperty<DateTimeOffset>("LastKeyRotationTimestamp", ["lastKeyRotationTimestamp"], isOutput: true);
    }
}
