// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// The service properties for soft delete.
/// </summary>
public partial class DeleteRetentionPolicy : ProvisionableConstruct
{
    /// <summary>
    /// Indicates whether DeleteRetentionPolicy is enabled.
    /// </summary>
    public BicepValue<bool> IsEnabled 
    {
        get { Initialize(); return _isEnabled!; }
        set { Initialize(); _isEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isEnabled;

    /// <summary>
    /// Indicates the number of days that the deleted item should be retained.
    /// The minimum specified value can be 1 and the maximum value can be 365.
    /// </summary>
    public BicepValue<int> Days 
    {
        get { Initialize(); return _days!; }
        set { Initialize(); _days!.Assign(value); }
    }
    private BicepValue<int>? _days;

    /// <summary>
    /// This property when set to true allows deletion of the soft deleted blob
    /// versions and snapshots. This property cannot be used blob restore
    /// policy. This property only applies to blob service and does not apply
    /// to containers or file share.
    /// </summary>
    public BicepValue<bool> AllowPermanentDelete 
    {
        get { Initialize(); return _allowPermanentDelete!; }
        set { Initialize(); _allowPermanentDelete!.Assign(value); }
    }
    private BicepValue<bool>? _allowPermanentDelete;

    /// <summary>
    /// Creates a new DeleteRetentionPolicy.
    /// </summary>
    public DeleteRetentionPolicy()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of DeleteRetentionPolicy.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _isEnabled = DefineProperty<bool>("IsEnabled", ["enabled"]);
        _days = DefineProperty<int>("Days", ["days"]);
        _allowPermanentDelete = DefineProperty<bool>("AllowPermanentDelete", ["allowPermanentDelete"]);
    }
}
