// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// Object to define the base blob action conditions. Properties
/// daysAfterModificationGreaterThan, daysAfterLastAccessTimeGreaterThan and
/// daysAfterCreationGreaterThan are mutually exclusive. The
/// daysAfterLastTierChangeGreaterThan property is only applicable for
/// tierToArchive actions which requires daysAfterModificationGreaterThan to
/// be set, also it cannot be used in conjunction with
/// daysAfterLastAccessTimeGreaterThan or daysAfterCreationGreaterThan.
/// </summary>
public partial class DateAfterModification : ProvisionableConstruct
{
    /// <summary>
    /// Value indicating the age in days after last modification.
    /// </summary>
    public BicepValue<float> DaysAfterModificationGreaterThan 
    {
        get { Initialize(); return _daysAfterModificationGreaterThan!; }
        set { Initialize(); _daysAfterModificationGreaterThan!.Assign(value); }
    }
    private BicepValue<float>? _daysAfterModificationGreaterThan;

    /// <summary>
    /// Value indicating the age in days after last blob access. This property
    /// can only be used in conjunction with last access time tracking policy.
    /// </summary>
    public BicepValue<float> DaysAfterLastAccessTimeGreaterThan 
    {
        get { Initialize(); return _daysAfterLastAccessTimeGreaterThan!; }
        set { Initialize(); _daysAfterLastAccessTimeGreaterThan!.Assign(value); }
    }
    private BicepValue<float>? _daysAfterLastAccessTimeGreaterThan;

    /// <summary>
    /// Value indicating the age in days after last blob tier change time. This
    /// property is only applicable for tierToArchive actions and requires
    /// daysAfterModificationGreaterThan to be set for baseBlobs based
    /// actions. The blob will be archived if both the conditions are
    /// satisfied.
    /// </summary>
    public BicepValue<float> DaysAfterLastTierChangeGreaterThan 
    {
        get { Initialize(); return _daysAfterLastTierChangeGreaterThan!; }
        set { Initialize(); _daysAfterLastTierChangeGreaterThan!.Assign(value); }
    }
    private BicepValue<float>? _daysAfterLastTierChangeGreaterThan;

    /// <summary>
    /// Value indicating the age in days after blob creation.
    /// </summary>
    public BicepValue<float> DaysAfterCreationGreaterThan 
    {
        get { Initialize(); return _daysAfterCreationGreaterThan!; }
        set { Initialize(); _daysAfterCreationGreaterThan!.Assign(value); }
    }
    private BicepValue<float>? _daysAfterCreationGreaterThan;

    /// <summary>
    /// Creates a new DateAfterModification.
    /// </summary>
    public DateAfterModification()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of DateAfterModification.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _daysAfterModificationGreaterThan = DefineProperty<float>("DaysAfterModificationGreaterThan", ["daysAfterModificationGreaterThan"]);
        _daysAfterLastAccessTimeGreaterThan = DefineProperty<float>("DaysAfterLastAccessTimeGreaterThan", ["daysAfterLastAccessTimeGreaterThan"]);
        _daysAfterLastTierChangeGreaterThan = DefineProperty<float>("DaysAfterLastTierChangeGreaterThan", ["daysAfterLastTierChangeGreaterThan"]);
        _daysAfterCreationGreaterThan = DefineProperty<float>("DaysAfterCreationGreaterThan", ["daysAfterCreationGreaterThan"]);
    }
}
