// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// Object to define snapshot and version action conditions.
/// </summary>
public partial class DateAfterCreation : ProvisionableConstruct
{
    /// <summary>
    /// Value indicating the age in days after creation.
    /// </summary>
    public BicepValue<float> DaysAfterCreationGreaterThan 
    {
        get { Initialize(); return _daysAfterCreationGreaterThan!; }
        set { Initialize(); _daysAfterCreationGreaterThan!.Assign(value); }
    }
    private BicepValue<float>? _daysAfterCreationGreaterThan;

    /// <summary>
    /// Value indicating the age in days after last blob tier change time. This
    /// property is only applicable for tierToArchive actions and requires
    /// daysAfterCreationGreaterThan to be set for snapshots and blob version
    /// based actions. The blob will be archived if both the conditions are
    /// satisfied.
    /// </summary>
    public BicepValue<float> DaysAfterLastTierChangeGreaterThan 
    {
        get { Initialize(); return _daysAfterLastTierChangeGreaterThan!; }
        set { Initialize(); _daysAfterLastTierChangeGreaterThan!.Assign(value); }
    }
    private BicepValue<float>? _daysAfterLastTierChangeGreaterThan;

    /// <summary>
    /// Creates a new DateAfterCreation.
    /// </summary>
    public DateAfterCreation()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of DateAfterCreation.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _daysAfterCreationGreaterThan = DefineProperty<float>("DaysAfterCreationGreaterThan", ["daysAfterCreationGreaterThan"]);
        _daysAfterLastTierChangeGreaterThan = DefineProperty<float>("DaysAfterLastTierChangeGreaterThan", ["daysAfterLastTierChangeGreaterThan"]);
    }
}
