// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// Blob restore status.
/// </summary>
public partial class BlobRestoreStatus : ProvisionableConstruct
{
    /// <summary>
    /// The status of blob restore progress. Possible values are: - InProgress:
    /// Indicates that blob restore is ongoing. - Complete: Indicates that
    /// blob restore has been completed successfully. - Failed: Indicates that
    /// blob restore is failed.
    /// </summary>
    public BicepValue<BlobRestoreProgressStatus> Status 
    {
        get { Initialize(); return _status!; }
    }
    private BicepValue<BlobRestoreProgressStatus>? _status;

    /// <summary>
    /// Failure reason when blob restore is failed.
    /// </summary>
    public BicepValue<string> FailureReason 
    {
        get { Initialize(); return _failureReason!; }
    }
    private BicepValue<string>? _failureReason;

    /// <summary>
    /// Id for tracking blob restore request.
    /// </summary>
    public BicepValue<string> RestoreId 
    {
        get { Initialize(); return _restoreId!; }
    }
    private BicepValue<string>? _restoreId;

    /// <summary>
    /// Blob restore request parameters.
    /// </summary>
    public BlobRestoreContent Parameters 
    {
        get { Initialize(); return _parameters!; }
    }
    private BlobRestoreContent? _parameters;

    /// <summary>
    /// Creates a new BlobRestoreStatus.
    /// </summary>
    public BlobRestoreStatus()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of BlobRestoreStatus.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _status = DefineProperty<BlobRestoreProgressStatus>("Status", ["status"], isOutput: true);
        _failureReason = DefineProperty<string>("FailureReason", ["failureReason"], isOutput: true);
        _restoreId = DefineProperty<string>("RestoreId", ["restoreId"], isOutput: true);
        _parameters = DefineModelProperty<BlobRestoreContent>("Parameters", ["parameters"], isOutput: true);
    }
}
