// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// Blob range.
/// </summary>
public partial class BlobRestoreRange : ProvisionableConstruct
{
    /// <summary>
    /// Blob start range. This is inclusive. Empty means account start.
    /// </summary>
    public BicepValue<string> StartRange 
    {
        get { Initialize(); return _startRange!; }
        set { Initialize(); _startRange!.Assign(value); }
    }
    private BicepValue<string>? _startRange;

    /// <summary>
    /// Blob end range. This is exclusive. Empty means account end.
    /// </summary>
    public BicepValue<string> EndRange 
    {
        get { Initialize(); return _endRange!; }
        set { Initialize(); _endRange!.Assign(value); }
    }
    private BicepValue<string>? _endRange;

    /// <summary>
    /// Creates a new BlobRestoreRange.
    /// </summary>
    public BlobRestoreRange()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of BlobRestoreRange.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _startRange = DefineProperty<string>("StartRange", ["startRange"]);
        _endRange = DefineProperty<string>("EndRange", ["endRange"]);
    }
}
