// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// The storage account blob inventory policy rules.
/// </summary>
public partial class BlobInventoryPolicySchema : ProvisionableConstruct
{
    /// <summary>
    /// Policy is enabled if set to true.
    /// </summary>
    public BicepValue<bool> IsEnabled 
    {
        get { Initialize(); return _isEnabled!; }
        set { Initialize(); _isEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isEnabled;

    /// <summary>
    /// Deprecated Property from API version 2021-04-01 onwards, the required
    /// destination container name must be specified at the rule level
    /// &apos;policy.rule.destination&apos;.
    /// </summary>
    public BicepValue<string> Destination 
    {
        get { Initialize(); return _destination!; }
    }
    private BicepValue<string>? _destination;

    /// <summary>
    /// The valid value is Inventory.
    /// </summary>
    public BicepValue<BlobInventoryRuleType> RuleType 
    {
        get { Initialize(); return _ruleType!; }
        set { Initialize(); _ruleType!.Assign(value); }
    }
    private BicepValue<BlobInventoryRuleType>? _ruleType;

    /// <summary>
    /// The storage account blob inventory policy rules. The rule is applied
    /// when it is enabled.
    /// </summary>
    public BicepList<BlobInventoryPolicyRule> Rules 
    {
        get { Initialize(); return _rules!; }
        set { Initialize(); _rules!.Assign(value); }
    }
    private BicepList<BlobInventoryPolicyRule>? _rules;

    /// <summary>
    /// Creates a new BlobInventoryPolicySchema.
    /// </summary>
    public BlobInventoryPolicySchema()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of BlobInventoryPolicySchema.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _isEnabled = DefineProperty<bool>("IsEnabled", ["enabled"]);
        _destination = DefineProperty<string>("Destination", ["destination"], isOutput: true);
        _ruleType = DefineProperty<BlobInventoryRuleType>("RuleType", ["type"]);
        _rules = DefineListProperty<BlobInventoryPolicyRule>("Rules", ["rules"]);
    }
}
