// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// An object that wraps the blob inventory rule. Each rule is uniquely defined
/// by name.
/// </summary>
public partial class BlobInventoryPolicyRule : ProvisionableConstruct
{
    /// <summary>
    /// Rule is enabled when set to true.
    /// </summary>
    public BicepValue<bool> IsEnabled 
    {
        get { Initialize(); return _isEnabled!; }
        set { Initialize(); _isEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isEnabled;

    /// <summary>
    /// A rule name can contain any combination of alpha numeric characters.
    /// Rule name is case-sensitive. It must be unique within a policy.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Container name where blob inventory files are stored. Must be
    /// pre-created.
    /// </summary>
    public BicepValue<string> Destination 
    {
        get { Initialize(); return _destination!; }
        set { Initialize(); _destination!.Assign(value); }
    }
    private BicepValue<string>? _destination;

    /// <summary>
    /// An object that defines the blob inventory policy rule.
    /// </summary>
    public BlobInventoryPolicyDefinition Definition 
    {
        get { Initialize(); return _definition!; }
        set { Initialize(); AssignOrReplace(ref _definition, value); }
    }
    private BlobInventoryPolicyDefinition? _definition;

    /// <summary>
    /// Creates a new BlobInventoryPolicyRule.
    /// </summary>
    public BlobInventoryPolicyRule()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of BlobInventoryPolicyRule.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _isEnabled = DefineProperty<bool>("IsEnabled", ["enabled"]);
        _name = DefineProperty<string>("Name", ["name"]);
        _destination = DefineProperty<string>("Destination", ["destination"]);
        _definition = DefineModelProperty<BlobInventoryPolicyDefinition>("Definition", ["definition"]);
    }
}
