// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// An object that defines the blob inventory rule filter conditions. For
/// &apos;Blob&apos; definition.objectType all filter properties are
/// applicable, &apos;blobTypes&apos; is required and others are optional. For
/// &apos;Container&apos; definition.objectType only prefixMatch is applicable
/// and is optional.
/// </summary>
public partial class BlobInventoryPolicyFilter : ProvisionableConstruct
{
    /// <summary>
    /// An array of strings with maximum 10 blob prefixes to be included in the
    /// inventory.
    /// </summary>
    public BicepList<string> IncludePrefix 
    {
        get { Initialize(); return _includePrefix!; }
        set { Initialize(); _includePrefix!.Assign(value); }
    }
    private BicepList<string>? _includePrefix;

    /// <summary>
    /// An array of strings with maximum 10 blob prefixes to be excluded from
    /// the inventory.
    /// </summary>
    public BicepList<string> ExcludePrefix 
    {
        get { Initialize(); return _excludePrefix!; }
        set { Initialize(); _excludePrefix!.Assign(value); }
    }
    private BicepList<string>? _excludePrefix;

    /// <summary>
    /// An array of predefined enum values. Valid values include blockBlob,
    /// appendBlob, pageBlob. Hns accounts does not support pageBlobs. This
    /// field is required when definition.objectType property is set to
    /// &apos;Blob&apos;.
    /// </summary>
    public BicepList<string> BlobTypes 
    {
        get { Initialize(); return _blobTypes!; }
        set { Initialize(); _blobTypes!.Assign(value); }
    }
    private BicepList<string>? _blobTypes;

    /// <summary>
    /// Includes blob versions in blob inventory when value is set to true. The
    /// definition.schemaFields values &apos;VersionId and
    /// IsCurrentVersion&apos; are required if this property is set to true,
    /// else they must be excluded.
    /// </summary>
    public BicepValue<bool> IncludeBlobVersions 
    {
        get { Initialize(); return _includeBlobVersions!; }
        set { Initialize(); _includeBlobVersions!.Assign(value); }
    }
    private BicepValue<bool>? _includeBlobVersions;

    /// <summary>
    /// Includes blob snapshots in blob inventory when value is set to true.
    /// The definition.schemaFields value &apos;Snapshot&apos; is required if
    /// this property is set to true, else it must be excluded.
    /// </summary>
    public BicepValue<bool> IncludeSnapshots 
    {
        get { Initialize(); return _includeSnapshots!; }
        set { Initialize(); _includeSnapshots!.Assign(value); }
    }
    private BicepValue<bool>? _includeSnapshots;

    /// <summary>
    /// For &apos;Container&apos; definition.objectType the
    /// definition.schemaFields must include &apos;Deleted, Version,
    /// DeletedTime and RemainingRetentionDays&apos;. For &apos;Blob&apos;
    /// definition.objectType and HNS enabled storage accounts the
    /// definition.schemaFields must include &apos;DeletionId, Deleted,
    /// DeletedTime and RemainingRetentionDays&apos; and for Hns disabled
    /// accounts the definition.schemaFields must include &apos;Deleted and
    /// RemainingRetentionDays&apos;, else it must be excluded.
    /// </summary>
    public BicepValue<bool> IncludeDeleted 
    {
        get { Initialize(); return _includeDeleted!; }
        set { Initialize(); _includeDeleted!.Assign(value); }
    }
    private BicepValue<bool>? _includeDeleted;

    /// <summary>
    /// Creates a new BlobInventoryPolicyFilter.
    /// </summary>
    public BlobInventoryPolicyFilter()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of BlobInventoryPolicyFilter.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _includePrefix = DefineListProperty<string>("IncludePrefix", ["prefixMatch"]);
        _excludePrefix = DefineListProperty<string>("ExcludePrefix", ["excludePrefix"]);
        _blobTypes = DefineListProperty<string>("BlobTypes", ["blobTypes"]);
        _includeBlobVersions = DefineProperty<bool>("IncludeBlobVersions", ["includeBlobVersions"]);
        _includeSnapshots = DefineProperty<bool>("IncludeSnapshots", ["includeSnapshots"]);
        _includeDeleted = DefineProperty<bool>("IncludeDeleted", ["includeDeleted"]);
    }
}
