// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// An object that defines the blob inventory rule.
/// </summary>
public partial class BlobInventoryPolicyDefinition : ProvisionableConstruct
{
    /// <summary>
    /// An object that defines the filter set.
    /// </summary>
    public BlobInventoryPolicyFilter Filters 
    {
        get { Initialize(); return _filters!; }
        set { Initialize(); AssignOrReplace(ref _filters, value); }
    }
    private BlobInventoryPolicyFilter? _filters;

    /// <summary>
    /// This is a required field, it specifies the format for the inventory
    /// files.
    /// </summary>
    public BicepValue<BlobInventoryPolicyFormat> Format 
    {
        get { Initialize(); return _format!; }
        set { Initialize(); _format!.Assign(value); }
    }
    private BicepValue<BlobInventoryPolicyFormat>? _format;

    /// <summary>
    /// This is a required field. This field is used to schedule an inventory
    /// formation.
    /// </summary>
    public BicepValue<BlobInventoryPolicySchedule> Schedule 
    {
        get { Initialize(); return _schedule!; }
        set { Initialize(); _schedule!.Assign(value); }
    }
    private BicepValue<BlobInventoryPolicySchedule>? _schedule;

    /// <summary>
    /// This is a required field. This field specifies the scope of the
    /// inventory created either at the blob or container level.
    /// </summary>
    public BicepValue<BlobInventoryPolicyObjectType> ObjectType 
    {
        get { Initialize(); return _objectType!; }
        set { Initialize(); _objectType!.Assign(value); }
    }
    private BicepValue<BlobInventoryPolicyObjectType>? _objectType;

    /// <summary>
    /// This is a required field. This field specifies the fields and
    /// properties of the object to be included in the inventory. The Schema
    /// field value &apos;Name&apos; is always required. The valid values for
    /// this field for the &apos;Blob&apos; definition.objectType include
    /// &apos;Name, Creation-Time, Last-Modified, Content-Length, Content-MD5,
    /// BlobType, AccessTier, AccessTierChangeTime, AccessTierInferred, Tags,
    /// Expiry-Time, hdi_isfolder, Owner, Group, Permissions, Acl, Snapshot,
    /// VersionId, IsCurrentVersion, Metadata, LastAccessTime, Tags, Etag,
    /// ContentType, ContentEncoding, ContentLanguage, ContentCRC64,
    /// CacheControl, ContentDisposition, LeaseStatus, LeaseState,
    /// LeaseDuration, ServerEncrypted, Deleted, DeletionId, DeletedTime,
    /// RemainingRetentionDays, ImmutabilityPolicyUntilDate,
    /// ImmutabilityPolicyMode, LegalHold, CopyId, CopyStatus, CopySource,
    /// CopyProgress, CopyCompletionTime, CopyStatusDescription,
    /// CustomerProvidedKeySha256, RehydratePriority, ArchiveStatus,
    /// XmsBlobSequenceNumber, EncryptionScope, IncrementalCopy,
    /// TagCount&apos;. For Blob object type schema field value
    /// &apos;DeletedTime&apos; is applicable only for Hns enabled accounts.
    /// The valid values for &apos;Container&apos; definition.objectType
    /// include &apos;Name, Last-Modified, Metadata, LeaseStatus, LeaseState,
    /// LeaseDuration, PublicAccess, HasImmutabilityPolicy, HasLegalHold,
    /// Etag, DefaultEncryptionScope, DenyEncryptionScopeOverride,
    /// ImmutableStorageWithVersioningEnabled, Deleted, Version, DeletedTime,
    /// RemainingRetentionDays&apos;. Schema field values &apos;Expiry-Time,
    /// hdi_isfolder, Owner, Group, Permissions, Acl, DeletionId&apos; are
    /// valid only for Hns enabled accounts.Schema field values &apos;Tags,
    /// TagCount&apos; are only valid for Non-Hns accounts.
    /// </summary>
    public BicepList<string> SchemaFields 
    {
        get { Initialize(); return _schemaFields!; }
        set { Initialize(); _schemaFields!.Assign(value); }
    }
    private BicepList<string>? _schemaFields;

    /// <summary>
    /// Creates a new BlobInventoryPolicyDefinition.
    /// </summary>
    public BlobInventoryPolicyDefinition()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// BlobInventoryPolicyDefinition.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _filters = DefineModelProperty<BlobInventoryPolicyFilter>("Filters", ["filters"]);
        _format = DefineProperty<BlobInventoryPolicyFormat>("Format", ["format"]);
        _schedule = DefineProperty<BlobInventoryPolicySchedule>("Schedule", ["schedule"]);
        _objectType = DefineProperty<BlobInventoryPolicyObjectType>("ObjectType", ["objectType"]);
        _schemaFields = DefineListProperty<string>("SchemaFields", ["schemaFields"]);
    }
}
