// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// The properties of an ImmutabilityPolicy of a blob container.
/// </summary>
public partial class BlobContainerImmutabilityPolicy : ProvisionableConstruct
{
    /// <summary>
    /// ImmutabilityPolicy Etag.
    /// </summary>
    public BicepValue<ETag> ETag 
    {
        get { Initialize(); return _eTag!; }
    }
    private BicepValue<ETag>? _eTag;

    /// <summary>
    /// The ImmutabilityPolicy update history of the blob container.
    /// </summary>
    public BicepList<UpdateHistoryEntry> UpdateHistory 
    {
        get { Initialize(); return _updateHistory!; }
    }
    private BicepList<UpdateHistoryEntry>? _updateHistory;

    /// <summary>
    /// The immutability period for the blobs in the container since the policy
    /// creation, in days.
    /// </summary>
    public BicepValue<int> ImmutabilityPeriodSinceCreationInDays 
    {
        get { Initialize(); return _immutabilityPeriodSinceCreationInDays!; }
    }
    private BicepValue<int>? _immutabilityPeriodSinceCreationInDays;

    /// <summary>
    /// The ImmutabilityPolicy state of a blob container, possible values
    /// include: Locked and Unlocked.
    /// </summary>
    public BicepValue<ImmutabilityPolicyState> State 
    {
        get { Initialize(); return _state!; }
    }
    private BicepValue<ImmutabilityPolicyState>? _state;

    /// <summary>
    /// This property can only be changed for unlocked time-based retention
    /// policies. When enabled, new blocks can be written to an append blob
    /// while maintaining immutability protection and compliance. Only new
    /// blocks can be added and any existing blocks cannot be modified or
    /// deleted. This property cannot be changed with ExtendImmutabilityPolicy
    /// API.
    /// </summary>
    public BicepValue<bool> AllowProtectedAppendWrites 
    {
        get { Initialize(); return _allowProtectedAppendWrites!; }
    }
    private BicepValue<bool>? _allowProtectedAppendWrites;

    /// <summary>
    /// This property can only be changed for unlocked time-based retention
    /// policies. When enabled, new blocks can be written to both &apos;Append
    /// and Bock Blobs&apos; while maintaining immutability protection and
    /// compliance. Only new blocks can be added and any existing blocks
    /// cannot be modified or deleted. This property cannot be changed with
    /// ExtendImmutabilityPolicy API. The
    /// &apos;allowProtectedAppendWrites&apos; and
    /// &apos;allowProtectedAppendWritesAll&apos; properties are mutually
    /// exclusive.
    /// </summary>
    public BicepValue<bool> AllowProtectedAppendWritesAll 
    {
        get { Initialize(); return _allowProtectedAppendWritesAll!; }
    }
    private BicepValue<bool>? _allowProtectedAppendWritesAll;

    /// <summary>
    /// Creates a new BlobContainerImmutabilityPolicy.
    /// </summary>
    public BlobContainerImmutabilityPolicy()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// BlobContainerImmutabilityPolicy.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _eTag = DefineProperty<ETag>("ETag", ["etag"], isOutput: true);
        _updateHistory = DefineListProperty<UpdateHistoryEntry>("UpdateHistory", ["updateHistory"], isOutput: true);
        _immutabilityPeriodSinceCreationInDays = DefineProperty<int>("ImmutabilityPeriodSinceCreationInDays", ["properties", "immutabilityPeriodSinceCreationInDays"], isOutput: true);
        _state = DefineProperty<ImmutabilityPolicyState>("State", ["properties", "state"], isOutput: true);
        _allowProtectedAppendWrites = DefineProperty<bool>("AllowProtectedAppendWrites", ["properties", "allowProtectedAppendWrites"], isOutput: true);
        _allowProtectedAppendWritesAll = DefineProperty<bool>("AllowProtectedAppendWritesAll", ["properties", "allowProtectedAppendWritesAll"], isOutput: true);
    }
}
