// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// This defines account-level immutability policy properties.
/// </summary>
public partial class AccountImmutabilityPolicy : ProvisionableConstruct
{
    /// <summary>
    /// The immutability period for the blobs in the container since the policy
    /// creation, in days.
    /// </summary>
    public BicepValue<int> ImmutabilityPeriodSinceCreationInDays 
    {
        get { Initialize(); return _immutabilityPeriodSinceCreationInDays!; }
        set { Initialize(); _immutabilityPeriodSinceCreationInDays!.Assign(value); }
    }
    private BicepValue<int>? _immutabilityPeriodSinceCreationInDays;

    /// <summary>
    /// The ImmutabilityPolicy state defines the mode of the policy. Disabled
    /// state disables the policy, Unlocked state allows increase and decrease
    /// of immutability retention time and also allows toggling
    /// allowProtectedAppendWrites property, Locked state only allows the
    /// increase of the immutability retention time. A policy can only be
    /// created in a Disabled or Unlocked state and can be toggled between the
    /// two states. Only a policy in an Unlocked state can transition to a
    /// Locked state which cannot be reverted.
    /// </summary>
    public BicepValue<AccountImmutabilityPolicyState> State 
    {
        get { Initialize(); return _state!; }
        set { Initialize(); _state!.Assign(value); }
    }
    private BicepValue<AccountImmutabilityPolicyState>? _state;

    /// <summary>
    /// This property can only be changed for disabled and unlocked time-based
    /// retention policies. When enabled, new blocks can be written to an
    /// append blob while maintaining immutability protection and compliance.
    /// Only new blocks can be added and any existing blocks cannot be
    /// modified or deleted.
    /// </summary>
    public BicepValue<bool> AllowProtectedAppendWrites 
    {
        get { Initialize(); return _allowProtectedAppendWrites!; }
        set { Initialize(); _allowProtectedAppendWrites!.Assign(value); }
    }
    private BicepValue<bool>? _allowProtectedAppendWrites;

    /// <summary>
    /// Creates a new AccountImmutabilityPolicy.
    /// </summary>
    public AccountImmutabilityPolicy()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of AccountImmutabilityPolicy.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _immutabilityPeriodSinceCreationInDays = DefineProperty<int>("ImmutabilityPeriodSinceCreationInDays", ["immutabilityPeriodSinceCreationInDays"]);
        _state = DefineProperty<AccountImmutabilityPolicyState>("State", ["state"]);
        _allowProtectedAppendWrites = DefineProperty<bool>("AllowProtectedAppendWrites", ["allowProtectedAppendWrites"]);
    }
}
