// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure;
using Azure.Core;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// ImmutabilityPolicy.
/// </summary>
public partial class ImmutabilityPolicy : ProvisionableResource
{
    /// <summary>
    /// Gets the Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// This property can only be changed for unlocked time-based retention
    /// policies. When enabled, new blocks can be written to an append blob
    /// while maintaining immutability protection and compliance. Only new
    /// blocks can be added and any existing blocks cannot be modified or
    /// deleted. This property cannot be changed with ExtendImmutabilityPolicy
    /// API.
    /// </summary>
    public BicepValue<bool> AllowProtectedAppendWrites 
    {
        get { Initialize(); return _allowProtectedAppendWrites!; }
        set { Initialize(); _allowProtectedAppendWrites!.Assign(value); }
    }
    private BicepValue<bool>? _allowProtectedAppendWrites;

    /// <summary>
    /// This property can only be changed for unlocked time-based retention
    /// policies. When enabled, new blocks can be written to both &apos;Append
    /// and Bock Blobs&apos; while maintaining immutability protection and
    /// compliance. Only new blocks can be added and any existing blocks
    /// cannot be modified or deleted. This property cannot be changed with
    /// ExtendImmutabilityPolicy API. The
    /// &apos;allowProtectedAppendWrites&apos; and
    /// &apos;allowProtectedAppendWritesAll&apos; properties are mutually
    /// exclusive.
    /// </summary>
    public BicepValue<bool> AllowProtectedAppendWritesAll 
    {
        get { Initialize(); return _allowProtectedAppendWritesAll!; }
        set { Initialize(); _allowProtectedAppendWritesAll!.Assign(value); }
    }
    private BicepValue<bool>? _allowProtectedAppendWritesAll;

    /// <summary>
    /// The immutability period for the blobs in the container since the policy
    /// creation, in days.
    /// </summary>
    public BicepValue<int> ImmutabilityPeriodSinceCreationInDays 
    {
        get { Initialize(); return _immutabilityPeriodSinceCreationInDays!; }
        set { Initialize(); _immutabilityPeriodSinceCreationInDays!.Assign(value); }
    }
    private BicepValue<int>? _immutabilityPeriodSinceCreationInDays;

    /// <summary>
    /// Resource Etag.
    /// </summary>
    public BicepValue<ETag> ETag 
    {
        get { Initialize(); return _eTag!; }
    }
    private BicepValue<ETag>? _eTag;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// The ImmutabilityPolicy state of a blob container, possible values
    /// include: Locked and Unlocked.
    /// </summary>
    public BicepValue<ImmutabilityPolicyState> State 
    {
        get { Initialize(); return _state!; }
    }
    private BicepValue<ImmutabilityPolicyState>? _state;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent BlobContainer.
    /// </summary>
    public BlobContainer? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<BlobContainer>? _parent;

    /// <summary>
    /// Creates a new ImmutabilityPolicy.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ImmutabilityPolicy resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ImmutabilityPolicy.</param>
    public ImmutabilityPolicy(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Storage/storageAccounts/blobServices/containers/immutabilityPolicies", resourceVersion ?? "2024-01-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ImmutabilityPolicy.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _allowProtectedAppendWrites = DefineProperty<bool>("AllowProtectedAppendWrites", ["properties", "allowProtectedAppendWrites"]);
        _allowProtectedAppendWritesAll = DefineProperty<bool>("AllowProtectedAppendWritesAll", ["properties", "allowProtectedAppendWritesAll"]);
        _immutabilityPeriodSinceCreationInDays = DefineProperty<int>("ImmutabilityPeriodSinceCreationInDays", ["properties", "immutabilityPeriodSinceCreationInDays"]);
        _eTag = DefineProperty<ETag>("ETag", ["etag"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _state = DefineProperty<ImmutabilityPolicyState>("State", ["properties", "state"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<BlobContainer>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported ImmutabilityPolicy resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-01-01.
        /// </summary>
        public static readonly string V2024_01_01 = "2024-01-01";

        /// <summary>
        /// 2023-05-01.
        /// </summary>
        public static readonly string V2023_05_01 = "2023-05-01";

        /// <summary>
        /// 2023-04-01.
        /// </summary>
        public static readonly string V2023_04_01 = "2023-04-01";

        /// <summary>
        /// 2023-01-01.
        /// </summary>
        public static readonly string V2023_01_01 = "2023-01-01";

        /// <summary>
        /// 2022-09-01.
        /// </summary>
        public static readonly string V2022_09_01 = "2022-09-01";

        /// <summary>
        /// 2022-05-01.
        /// </summary>
        public static readonly string V2022_05_01 = "2022-05-01";

        /// <summary>
        /// 2021-09-01.
        /// </summary>
        public static readonly string V2021_09_01 = "2021-09-01";

        /// <summary>
        /// 2021-08-01.
        /// </summary>
        public static readonly string V2021_08_01 = "2021-08-01";

        /// <summary>
        /// 2021-06-01.
        /// </summary>
        public static readonly string V2021_06_01 = "2021-06-01";

        /// <summary>
        /// 2021-05-01.
        /// </summary>
        public static readonly string V2021_05_01 = "2021-05-01";

        /// <summary>
        /// 2021-04-01.
        /// </summary>
        public static readonly string V2021_04_01 = "2021-04-01";

        /// <summary>
        /// 2021-02-01.
        /// </summary>
        public static readonly string V2021_02_01 = "2021-02-01";

        /// <summary>
        /// 2021-01-01.
        /// </summary>
        public static readonly string V2021_01_01 = "2021-01-01";

        /// <summary>
        /// 2019-06-01.
        /// </summary>
        public static readonly string V2019_06_01 = "2019-06-01";

        /// <summary>
        /// 2019-04-01.
        /// </summary>
        public static readonly string V2019_04_01 = "2019-04-01";

        /// <summary>
        /// 2018-11-01.
        /// </summary>
        public static readonly string V2018_11_01 = "2018-11-01";

        /// <summary>
        /// 2018-07-01.
        /// </summary>
        public static readonly string V2018_07_01 = "2018-07-01";

        /// <summary>
        /// 2018-02-01.
        /// </summary>
        public static readonly string V2018_02_01 = "2018-02-01";

        /// <summary>
        /// 2017-10-01.
        /// </summary>
        public static readonly string V2017_10_01 = "2017-10-01";

        /// <summary>
        /// 2017-06-01.
        /// </summary>
        public static readonly string V2017_06_01 = "2017-06-01";

        /// <summary>
        /// 2016-12-01.
        /// </summary>
        public static readonly string V2016_12_01 = "2016-12-01";

        /// <summary>
        /// 2016-05-01.
        /// </summary>
        public static readonly string V2016_05_01 = "2016-05-01";
    }

    /// <summary>
    /// Creates a reference to an existing ImmutabilityPolicy.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ImmutabilityPolicy resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ImmutabilityPolicy.</param>
    /// <returns>The existing ImmutabilityPolicy resource.</returns>
    public static ImmutabilityPolicy FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
