// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure;
using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;
using System.ComponentModel;

namespace Azure.Provisioning.Storage;

/// <summary>
/// FileShare.
/// </summary>
public partial class FileShare : ProvisionableResource
{
    /// <summary>
    /// The name of the file share within the specified storage account. File
    /// share names must be between 3 and 63 characters in length and use
    /// numbers, lower-case letters and dash (-) only. Every dash (-)
    /// character must be immediately preceded and followed by a letter or
    /// number.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Access tier for specific share. GpV2 account can choose between
    /// TransactionOptimized (default), Hot, and Cool. FileStorage account can
    /// choose Premium.
    /// </summary>
    public BicepValue<FileShareAccessTier> AccessTier 
    {
        get { Initialize(); return _accessTier!; }
        set { Initialize(); _accessTier!.Assign(value); }
    }
    private BicepValue<FileShareAccessTier>? _accessTier;

    /// <summary>
    /// The authentication protocol that is used for the file share. Can only
    /// be specified when creating a share.
    /// </summary>
    public BicepValue<FileShareEnabledProtocol> EnabledProtocol 
    {
        get { Initialize(); return _enabledProtocol!; }
        set { Initialize(); _enabledProtocol!.Assign(value); }
    }
    private BicepValue<FileShareEnabledProtocol>? _enabledProtocol;

    /// <summary>
    /// A name-value pair to associate with the share as metadata.
    /// </summary>
    public BicepDictionary<string> Metadata 
    {
        get { Initialize(); return _metadata!; }
        set { Initialize(); _metadata!.Assign(value); }
    }
    private BicepDictionary<string>? _metadata;

    /// <summary>
    /// The property is for NFS share only. The default is NoRootSquash.
    /// </summary>
    public BicepValue<RootSquashType> RootSquash 
    {
        get { Initialize(); return _rootSquash!; }
        set { Initialize(); _rootSquash!.Assign(value); }
    }
    private BicepValue<RootSquashType>? _rootSquash;

    /// <summary>
    /// The maximum size of the share, in gigabytes. Must be greater than 0,
    /// and less than or equal to 5TB (5120). For Large File Shares, the
    /// maximum size is 102400.
    /// </summary>
    public BicepValue<int> ShareQuota 
    {
        get { Initialize(); return _shareQuota!; }
        set { Initialize(); _shareQuota!.Assign(value); }
    }
    private BicepValue<int>? _shareQuota;

    /// <summary>
    /// List of stored access policies specified on the share.
    /// </summary>
    public BicepList<StorageSignedIdentifier> SignedIdentifiers 
    {
        get { Initialize(); return _signedIdentifiers!; }
        set { Initialize(); _signedIdentifiers!.Assign(value); }
    }
    private BicepList<StorageSignedIdentifier>? _signedIdentifiers;

    /// <summary>
    /// Indicates the last modification time for share access tier.
    /// </summary>
    public BicepValue<DateTimeOffset> AccessTierChangeOn 
    {
        get { Initialize(); return _accessTierChangeOn!; }
    }
    private BicepValue<DateTimeOffset>? _accessTierChangeOn;

    /// <summary>
    /// Indicates if there is a pending transition for access tier.
    /// </summary>
    public BicepValue<string> AccessTierStatus 
    {
        get { Initialize(); return _accessTierStatus!; }
    }
    private BicepValue<string>? _accessTierStatus;

    /// <summary>
    /// The deleted time if the share was deleted.
    /// </summary>
    public BicepValue<DateTimeOffset> DeletedOn 
    {
        get { Initialize(); return _deletedOn!; }
    }
    private BicepValue<DateTimeOffset>? _deletedOn;

    /// <summary>
    /// Resource Etag.
    /// </summary>
    public BicepValue<ETag> ETag 
    {
        get { Initialize(); return _eTag!; }
    }
    private BicepValue<ETag>? _eTag;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Indicates whether the share was deleted.
    /// </summary>
    public BicepValue<bool> IsDeleted 
    {
        get { Initialize(); return _isDeleted!; }
    }
    private BicepValue<bool>? _isDeleted;

    /// <summary>
    /// Returns the date and time the share was last modified.
    /// </summary>
    public BicepValue<DateTimeOffset> LastModifiedOn 
    {
        get { Initialize(); return _lastModifiedOn!; }
    }
    private BicepValue<DateTimeOffset>? _lastModifiedOn;

    /// <summary>
    /// Specifies whether the lease on a share is of infinite or fixed
    /// duration, only when the share is leased.
    /// </summary>
    public BicepValue<StorageLeaseDurationType> LeaseDuration 
    {
        get { Initialize(); return _leaseDuration!; }
    }
    private BicepValue<StorageLeaseDurationType>? _leaseDuration;

    /// <summary>
    /// Lease state of the share.
    /// </summary>
    public BicepValue<StorageLeaseState> LeaseState 
    {
        get { Initialize(); return _leaseState!; }
    }
    private BicepValue<StorageLeaseState>? _leaseState;

    /// <summary>
    /// The lease status of the share.
    /// </summary>
    public BicepValue<StorageLeaseStatus> LeaseStatus 
    {
        get { Initialize(); return _leaseStatus!; }
    }
    private BicepValue<StorageLeaseStatus>? _leaseStatus;

    /// <summary>
    /// Remaining retention days for share that was soft deleted.
    /// </summary>
    public BicepValue<int> RemainingRetentionDays 
    {
        get { Initialize(); return _remainingRetentionDays!; }
    }
    private BicepValue<int>? _remainingRetentionDays;

    /// <summary>
    /// The approximate size of the data stored on the share. Note that this
    /// value may not include all recently created or recently resized files.
    /// </summary>
    public BicepValue<long> ShareUsageBytes 
    {
        get { Initialize(); return _shareUsageBytes!; }
    }
    private BicepValue<long>? _shareUsageBytes;

    /// <summary>
    /// Creation time of share snapshot returned in the response of list shares
    /// with expand param &quot;snapshots&quot;.
    /// </summary>
    public BicepValue<DateTimeOffset> SnapshotOn 
    {
        get { Initialize(); return _snapshotOn!; }
    }
    private BicepValue<DateTimeOffset>? _snapshotOn;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// The version of the share.
    /// </summary>
    public BicepValue<string> Version 
    {
        get { Initialize(); return _version!; }
    }
    private BicepValue<string>? _version;

    /// <summary>
    /// Gets or sets a reference to the parent FileService.
    /// </summary>
    public FileService? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<FileService>? _parent;

    /// <summary>
    /// Creates a new FileShare.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the FileShare resource.  This can be
    /// used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the FileShare.</param>
    public FileShare(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Storage/storageAccounts/fileServices/shares", resourceVersion ?? "2024-01-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of FileShare.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _accessTier = DefineProperty<FileShareAccessTier>("AccessTier", ["properties", "accessTier"]);
        _enabledProtocol = DefineProperty<FileShareEnabledProtocol>("EnabledProtocol", ["properties", "enabledProtocols"]);
        _metadata = DefineDictionaryProperty<string>("Metadata", ["properties", "metadata"]);
        _rootSquash = DefineProperty<RootSquashType>("RootSquash", ["properties", "rootSquash"]);
        _shareQuota = DefineProperty<int>("ShareQuota", ["properties", "shareQuota"]);
        _signedIdentifiers = DefineListProperty<StorageSignedIdentifier>("SignedIdentifiers", ["properties", "signedIdentifiers"]);
        _accessTierChangeOn = DefineProperty<DateTimeOffset>("AccessTierChangeOn", ["properties", "accessTierChangeTime"], isOutput: true);
        _accessTierStatus = DefineProperty<string>("AccessTierStatus", ["properties", "accessTierStatus"], isOutput: true);
        _deletedOn = DefineProperty<DateTimeOffset>("DeletedOn", ["properties", "deletedTime"], isOutput: true);
        _eTag = DefineProperty<ETag>("ETag", ["etag"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _isDeleted = DefineProperty<bool>("IsDeleted", ["properties", "deleted"], isOutput: true);
        _lastModifiedOn = DefineProperty<DateTimeOffset>("LastModifiedOn", ["properties", "lastModifiedTime"], isOutput: true);
        _leaseDuration = DefineProperty<StorageLeaseDurationType>("LeaseDuration", ["properties", "leaseDuration"], isOutput: true);
        _leaseState = DefineProperty<StorageLeaseState>("LeaseState", ["properties", "leaseState"], isOutput: true);
        _leaseStatus = DefineProperty<StorageLeaseStatus>("LeaseStatus", ["properties", "leaseStatus"], isOutput: true);
        _remainingRetentionDays = DefineProperty<int>("RemainingRetentionDays", ["properties", "remainingRetentionDays"], isOutput: true);
        _shareUsageBytes = DefineProperty<long>("ShareUsageBytes", ["properties", "shareUsageBytes"], isOutput: true);
        _snapshotOn = DefineProperty<DateTimeOffset>("SnapshotOn", ["properties", "snapshotTime"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _version = DefineProperty<string>("Version", ["properties", "version"], isOutput: true);
        _parent = DefineResource<FileService>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported FileShare resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-01-01.
        /// </summary>
        public static readonly string V2024_01_01 = "2024-01-01";

        /// <summary>
        /// 2023-05-01.
        /// </summary>
        public static readonly string V2023_05_01 = "2023-05-01";

        /// <summary>
        /// 2023-04-01.
        /// </summary>
        public static readonly string V2023_04_01 = "2023-04-01";

        /// <summary>
        /// 2023-01-01.
        /// </summary>
        public static readonly string V2023_01_01 = "2023-01-01";

        /// <summary>
        /// 2022-09-01.
        /// </summary>
        public static readonly string V2022_09_01 = "2022-09-01";

        /// <summary>
        /// 2022-05-01.
        /// </summary>
        public static readonly string V2022_05_01 = "2022-05-01";

        /// <summary>
        /// 2021-09-01.
        /// </summary>
        public static readonly string V2021_09_01 = "2021-09-01";

        /// <summary>
        /// 2021-08-01.
        /// </summary>
        public static readonly string V2021_08_01 = "2021-08-01";

        /// <summary>
        /// 2021-06-01.
        /// </summary>
        public static readonly string V2021_06_01 = "2021-06-01";

        /// <summary>
        /// 2021-05-01.
        /// </summary>
        public static readonly string V2021_05_01 = "2021-05-01";

        /// <summary>
        /// 2021-04-01.
        /// </summary>
        public static readonly string V2021_04_01 = "2021-04-01";

        /// <summary>
        /// 2021-02-01.
        /// </summary>
        public static readonly string V2021_02_01 = "2021-02-01";

        /// <summary>
        /// 2021-01-01.
        /// </summary>
        public static readonly string V2021_01_01 = "2021-01-01";

        /// <summary>
        /// 2019-06-01.
        /// </summary>
        public static readonly string V2019_06_01 = "2019-06-01";

        /// <summary>
        /// 2019-04-01.
        /// </summary>
        public static readonly string V2019_04_01 = "2019-04-01";

        /// <summary>
        /// 2018-11-01.
        /// </summary>
        public static readonly string V2018_11_01 = "2018-11-01";

        /// <summary>
        /// 2018-07-01.
        /// </summary>
        public static readonly string V2018_07_01 = "2018-07-01";

        /// <summary>
        /// 2018-02-01.
        /// </summary>
        public static readonly string V2018_02_01 = "2018-02-01";

        /// <summary>
        /// 2017-10-01.
        /// </summary>
        public static readonly string V2017_10_01 = "2017-10-01";

        /// <summary>
        /// 2017-06-01.
        /// </summary>
        public static readonly string V2017_06_01 = "2017-06-01";

        /// <summary>
        /// 2016-12-01.
        /// </summary>
        public static readonly string V2016_12_01 = "2016-12-01";

        /// <summary>
        /// 2016-05-01.
        /// </summary>
        public static readonly string V2016_05_01 = "2016-05-01";
    }

    /// <summary>
    /// Creates a reference to an existing FileShare.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the FileShare resource.  This can be
    /// used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the FileShare.</param>
    /// <returns>The existing FileShare resource.</returns>
    public static FileShare FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };

    /// <summary>
    /// Get the requirements for naming this FileShare resource.
    /// </summary>
    /// <returns>Naming requirements.</returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override ResourceNameRequirements GetResourceNameRequirements() =>
        new(minLength: 3, maxLength: 63, validCharacters: ResourceNameCharacters.LowercaseLetters | ResourceNameCharacters.Numbers | ResourceNameCharacters.Hyphen);
}
