// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// EncryptionScope.
/// </summary>
public partial class EncryptionScope : ProvisionableResource
{
    /// <summary>
    /// The name of the encryption scope within the specified storage account.
    /// Encryption scope names must be between 3 and 63 characters in length
    /// and use numbers, lower-case letters and dash (-) only. Every dash (-)
    /// character must be immediately preceded and followed by a letter or
    /// number.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The key vault properties for the encryption scope. This is a required
    /// field if encryption scope &apos;source&apos; attribute is set to
    /// &apos;Microsoft.KeyVault&apos;.
    /// </summary>
    public EncryptionScopeKeyVaultProperties KeyVaultProperties 
    {
        get { Initialize(); return _keyVaultProperties!; }
        set { Initialize(); AssignOrReplace(ref _keyVaultProperties, value); }
    }
    private EncryptionScopeKeyVaultProperties? _keyVaultProperties;

    /// <summary>
    /// A boolean indicating whether or not the service applies a secondary
    /// layer of encryption with platform managed keys for data at rest.
    /// </summary>
    public BicepValue<bool> RequireInfrastructureEncryption 
    {
        get { Initialize(); return _requireInfrastructureEncryption!; }
        set { Initialize(); _requireInfrastructureEncryption!.Assign(value); }
    }
    private BicepValue<bool>? _requireInfrastructureEncryption;

    /// <summary>
    /// The provider for the encryption scope. Possible values
    /// (case-insensitive):  Microsoft.Storage, Microsoft.KeyVault.
    /// </summary>
    public BicepValue<EncryptionScopeSource> Source 
    {
        get { Initialize(); return _source!; }
        set { Initialize(); _source!.Assign(value); }
    }
    private BicepValue<EncryptionScopeSource>? _source;

    /// <summary>
    /// The state of the encryption scope. Possible values (case-insensitive):
    /// Enabled, Disabled.
    /// </summary>
    public BicepValue<EncryptionScopeState> State 
    {
        get { Initialize(); return _state!; }
        set { Initialize(); _state!.Assign(value); }
    }
    private BicepValue<EncryptionScopeState>? _state;

    /// <summary>
    /// Gets the creation date and time of the encryption scope in UTC.
    /// </summary>
    public BicepValue<DateTimeOffset> CreatedOn 
    {
        get { Initialize(); return _createdOn!; }
    }
    private BicepValue<DateTimeOffset>? _createdOn;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the last modification date and time of the encryption scope in UTC.
    /// </summary>
    public BicepValue<DateTimeOffset> LastModifiedOn 
    {
        get { Initialize(); return _lastModifiedOn!; }
    }
    private BicepValue<DateTimeOffset>? _lastModifiedOn;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent StorageAccount.
    /// </summary>
    public StorageAccount? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<StorageAccount>? _parent;

    /// <summary>
    /// Creates a new EncryptionScope.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the EncryptionScope resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the EncryptionScope.</param>
    public EncryptionScope(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Storage/storageAccounts/encryptionScopes", resourceVersion ?? "2024-01-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of EncryptionScope.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _keyVaultProperties = DefineModelProperty<EncryptionScopeKeyVaultProperties>("KeyVaultProperties", ["properties", "keyVaultProperties"]);
        _requireInfrastructureEncryption = DefineProperty<bool>("RequireInfrastructureEncryption", ["properties", "requireInfrastructureEncryption"]);
        _source = DefineProperty<EncryptionScopeSource>("Source", ["properties", "source"]);
        _state = DefineProperty<EncryptionScopeState>("State", ["properties", "state"]);
        _createdOn = DefineProperty<DateTimeOffset>("CreatedOn", ["properties", "creationTime"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _lastModifiedOn = DefineProperty<DateTimeOffset>("LastModifiedOn", ["properties", "lastModifiedTime"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<StorageAccount>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported EncryptionScope resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-01-01.
        /// </summary>
        public static readonly string V2024_01_01 = "2024-01-01";

        /// <summary>
        /// 2023-05-01.
        /// </summary>
        public static readonly string V2023_05_01 = "2023-05-01";

        /// <summary>
        /// 2023-04-01.
        /// </summary>
        public static readonly string V2023_04_01 = "2023-04-01";

        /// <summary>
        /// 2023-01-01.
        /// </summary>
        public static readonly string V2023_01_01 = "2023-01-01";

        /// <summary>
        /// 2022-09-01.
        /// </summary>
        public static readonly string V2022_09_01 = "2022-09-01";

        /// <summary>
        /// 2022-05-01.
        /// </summary>
        public static readonly string V2022_05_01 = "2022-05-01";

        /// <summary>
        /// 2021-09-01.
        /// </summary>
        public static readonly string V2021_09_01 = "2021-09-01";

        /// <summary>
        /// 2021-08-01.
        /// </summary>
        public static readonly string V2021_08_01 = "2021-08-01";

        /// <summary>
        /// 2021-06-01.
        /// </summary>
        public static readonly string V2021_06_01 = "2021-06-01";

        /// <summary>
        /// 2021-05-01.
        /// </summary>
        public static readonly string V2021_05_01 = "2021-05-01";

        /// <summary>
        /// 2021-04-01.
        /// </summary>
        public static readonly string V2021_04_01 = "2021-04-01";

        /// <summary>
        /// 2021-02-01.
        /// </summary>
        public static readonly string V2021_02_01 = "2021-02-01";

        /// <summary>
        /// 2021-01-01.
        /// </summary>
        public static readonly string V2021_01_01 = "2021-01-01";

        /// <summary>
        /// 2019-06-01.
        /// </summary>
        public static readonly string V2019_06_01 = "2019-06-01";
    }

    /// <summary>
    /// Creates a reference to an existing EncryptionScope.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the EncryptionScope resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the EncryptionScope.</param>
    /// <returns>The existing EncryptionScope resource.</returns>
    public static EncryptionScope FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
