// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// BlobService.
/// </summary>
public partial class BlobService : ProvisionableResource
{
    private BicepValue<string>? _name;

    /// <summary>
    /// The blob service properties for change feed events.
    /// </summary>
    public BlobServiceChangeFeed ChangeFeed 
    {
        get { Initialize(); return _changeFeed!; }
        set { Initialize(); AssignOrReplace(ref _changeFeed, value); }
    }
    private BlobServiceChangeFeed? _changeFeed;

    /// <summary>
    /// The blob service properties for container soft delete.
    /// </summary>
    public DeleteRetentionPolicy ContainerDeleteRetentionPolicy 
    {
        get { Initialize(); return _containerDeleteRetentionPolicy!; }
        set { Initialize(); AssignOrReplace(ref _containerDeleteRetentionPolicy, value); }
    }
    private DeleteRetentionPolicy? _containerDeleteRetentionPolicy;

    /// <summary>
    /// The List of CORS rules. You can include up to five CorsRule elements in
    /// the request.
    /// </summary>
    public BicepList<StorageCorsRule> CorsRules 
    {
        get { Initialize(); return _corsRules!; }
        set { Initialize(); _corsRules!.Assign(value); }
    }
    private BicepList<StorageCorsRule>? _corsRules;

    /// <summary>
    /// DefaultServiceVersion indicates the default version to use for requests
    /// to the Blob service if an incoming request’s version is not specified.
    /// Possible values include version 2008-10-27 and all more recent
    /// versions.
    /// </summary>
    public BicepValue<string> DefaultServiceVersion 
    {
        get { Initialize(); return _defaultServiceVersion!; }
        set { Initialize(); _defaultServiceVersion!.Assign(value); }
    }
    private BicepValue<string>? _defaultServiceVersion;

    /// <summary>
    /// The blob service properties for blob soft delete.
    /// </summary>
    public DeleteRetentionPolicy DeleteRetentionPolicy 
    {
        get { Initialize(); return _deleteRetentionPolicy!; }
        set { Initialize(); AssignOrReplace(ref _deleteRetentionPolicy, value); }
    }
    private DeleteRetentionPolicy? _deleteRetentionPolicy;

    /// <summary>
    /// Deprecated in favor of isVersioningEnabled property.
    /// </summary>
    public BicepValue<bool> IsAutomaticSnapshotPolicyEnabled 
    {
        get { Initialize(); return _isAutomaticSnapshotPolicyEnabled!; }
        set { Initialize(); _isAutomaticSnapshotPolicyEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isAutomaticSnapshotPolicyEnabled;

    /// <summary>
    /// Versioning is enabled if set to true.
    /// </summary>
    public BicepValue<bool> IsVersioningEnabled 
    {
        get { Initialize(); return _isVersioningEnabled!; }
        set { Initialize(); _isVersioningEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isVersioningEnabled;

    /// <summary>
    /// The blob service property to configure last access time based tracking
    /// policy.
    /// </summary>
    public LastAccessTimeTrackingPolicy LastAccessTimeTrackingPolicy 
    {
        get { Initialize(); return _lastAccessTimeTrackingPolicy!; }
        set { Initialize(); AssignOrReplace(ref _lastAccessTimeTrackingPolicy, value); }
    }
    private LastAccessTimeTrackingPolicy? _lastAccessTimeTrackingPolicy;

    /// <summary>
    /// The blob service properties for blob restore policy.
    /// </summary>
    public RestorePolicy RestorePolicy 
    {
        get { Initialize(); return _restorePolicy!; }
        set { Initialize(); AssignOrReplace(ref _restorePolicy, value); }
    }
    private RestorePolicy? _restorePolicy;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Sku name and tier.
    /// </summary>
    public StorageSku Sku 
    {
        get { Initialize(); return _sku!; }
    }
    private StorageSku? _sku;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent StorageAccount.
    /// </summary>
    public StorageAccount? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<StorageAccount>? _parent;

    /// <summary>
    /// Get the default value for the Name property.
    /// </summary>
    private partial BicepValue<string> GetNameDefaultValue();

    /// <summary>
    /// Creates a new BlobService.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the BlobService resource.  This can be
    /// used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the BlobService.</param>
    public BlobService(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Storage/storageAccounts/blobServices", resourceVersion ?? "2024-01-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of BlobService.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], defaultValue: GetNameDefaultValue());
        _changeFeed = DefineModelProperty<BlobServiceChangeFeed>("ChangeFeed", ["properties", "changeFeed"]);
        _containerDeleteRetentionPolicy = DefineModelProperty<DeleteRetentionPolicy>("ContainerDeleteRetentionPolicy", ["properties", "containerDeleteRetentionPolicy"]);
        _corsRules = DefineListProperty<StorageCorsRule>("CorsRules", ["properties", "cors", "corsRules"]);
        _defaultServiceVersion = DefineProperty<string>("DefaultServiceVersion", ["properties", "defaultServiceVersion"]);
        _deleteRetentionPolicy = DefineModelProperty<DeleteRetentionPolicy>("DeleteRetentionPolicy", ["properties", "deleteRetentionPolicy"]);
        _isAutomaticSnapshotPolicyEnabled = DefineProperty<bool>("IsAutomaticSnapshotPolicyEnabled", ["properties", "automaticSnapshotPolicyEnabled"]);
        _isVersioningEnabled = DefineProperty<bool>("IsVersioningEnabled", ["properties", "isVersioningEnabled"]);
        _lastAccessTimeTrackingPolicy = DefineModelProperty<LastAccessTimeTrackingPolicy>("LastAccessTimeTrackingPolicy", ["properties", "lastAccessTimeTrackingPolicy"]);
        _restorePolicy = DefineModelProperty<RestorePolicy>("RestorePolicy", ["properties", "restorePolicy"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _sku = DefineModelProperty<StorageSku>("Sku", ["sku"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<StorageAccount>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported BlobService resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-01-01.
        /// </summary>
        public static readonly string V2024_01_01 = "2024-01-01";

        /// <summary>
        /// 2023-05-01.
        /// </summary>
        public static readonly string V2023_05_01 = "2023-05-01";

        /// <summary>
        /// 2023-04-01.
        /// </summary>
        public static readonly string V2023_04_01 = "2023-04-01";

        /// <summary>
        /// 2023-01-01.
        /// </summary>
        public static readonly string V2023_01_01 = "2023-01-01";

        /// <summary>
        /// 2022-09-01.
        /// </summary>
        public static readonly string V2022_09_01 = "2022-09-01";

        /// <summary>
        /// 2022-05-01.
        /// </summary>
        public static readonly string V2022_05_01 = "2022-05-01";

        /// <summary>
        /// 2021-09-01.
        /// </summary>
        public static readonly string V2021_09_01 = "2021-09-01";

        /// <summary>
        /// 2021-08-01.
        /// </summary>
        public static readonly string V2021_08_01 = "2021-08-01";

        /// <summary>
        /// 2021-06-01.
        /// </summary>
        public static readonly string V2021_06_01 = "2021-06-01";

        /// <summary>
        /// 2021-05-01.
        /// </summary>
        public static readonly string V2021_05_01 = "2021-05-01";

        /// <summary>
        /// 2021-04-01.
        /// </summary>
        public static readonly string V2021_04_01 = "2021-04-01";

        /// <summary>
        /// 2021-02-01.
        /// </summary>
        public static readonly string V2021_02_01 = "2021-02-01";

        /// <summary>
        /// 2021-01-01.
        /// </summary>
        public static readonly string V2021_01_01 = "2021-01-01";

        /// <summary>
        /// 2019-06-01.
        /// </summary>
        public static readonly string V2019_06_01 = "2019-06-01";

        /// <summary>
        /// 2019-04-01.
        /// </summary>
        public static readonly string V2019_04_01 = "2019-04-01";

        /// <summary>
        /// 2018-11-01.
        /// </summary>
        public static readonly string V2018_11_01 = "2018-11-01";

        /// <summary>
        /// 2018-07-01.
        /// </summary>
        public static readonly string V2018_07_01 = "2018-07-01";

        /// <summary>
        /// 2018-02-01.
        /// </summary>
        public static readonly string V2018_02_01 = "2018-02-01";

        /// <summary>
        /// 2017-10-01.
        /// </summary>
        public static readonly string V2017_10_01 = "2017-10-01";

        /// <summary>
        /// 2017-06-01.
        /// </summary>
        public static readonly string V2017_06_01 = "2017-06-01";

        /// <summary>
        /// 2016-12-01.
        /// </summary>
        public static readonly string V2016_12_01 = "2016-12-01";

        /// <summary>
        /// 2016-05-01.
        /// </summary>
        public static readonly string V2016_05_01 = "2016-05-01";
    }

    /// <summary>
    /// Creates a reference to an existing BlobService.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the BlobService resource.  This can be
    /// used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the BlobService.</param>
    /// <returns>The existing BlobService resource.</returns>
    public static BlobService FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
