// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure;
using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;
using System.ComponentModel;

namespace Azure.Provisioning.Storage;

/// <summary>
/// BlobContainer.
/// </summary>
public partial class BlobContainer : ProvisionableResource
{
    /// <summary>
    /// The name of the blob container within the specified storage account.
    /// Blob container names must be between 3 and 63 characters in length and
    /// use numbers, lower-case letters and dash (-) only. Every dash (-)
    /// character must be immediately preceded and followed by a letter or
    /// number.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Default the container to use specified encryption scope for all writes.
    /// </summary>
    public BicepValue<string> DefaultEncryptionScope 
    {
        get { Initialize(); return _defaultEncryptionScope!; }
        set { Initialize(); _defaultEncryptionScope!.Assign(value); }
    }
    private BicepValue<string>? _defaultEncryptionScope;

    /// <summary>
    /// Enable NFSv3 all squash on blob container.
    /// </summary>
    public BicepValue<bool> EnableNfsV3AllSquash 
    {
        get { Initialize(); return _enableNfsV3AllSquash!; }
        set { Initialize(); _enableNfsV3AllSquash!.Assign(value); }
    }
    private BicepValue<bool>? _enableNfsV3AllSquash;

    /// <summary>
    /// Enable NFSv3 root squash on blob container.
    /// </summary>
    public BicepValue<bool> EnableNfsV3RootSquash 
    {
        get { Initialize(); return _enableNfsV3RootSquash!; }
        set { Initialize(); _enableNfsV3RootSquash!.Assign(value); }
    }
    private BicepValue<bool>? _enableNfsV3RootSquash;

    /// <summary>
    /// The object level immutability property of the container. The property
    /// is immutable and can only be set to true at the container creation
    /// time. Existing containers must undergo a migration process.
    /// </summary>
    public ImmutableStorageWithVersioning ImmutableStorageWithVersioning 
    {
        get { Initialize(); return _immutableStorageWithVersioning!; }
        set { Initialize(); AssignOrReplace(ref _immutableStorageWithVersioning, value); }
    }
    private ImmutableStorageWithVersioning? _immutableStorageWithVersioning;

    /// <summary>
    /// A name-value pair to associate with the container as metadata.
    /// </summary>
    public BicepDictionary<string> Metadata 
    {
        get { Initialize(); return _metadata!; }
        set { Initialize(); _metadata!.Assign(value); }
    }
    private BicepDictionary<string>? _metadata;

    /// <summary>
    /// Block override of encryption scope from the container default.
    /// </summary>
    public BicepValue<bool> PreventEncryptionScopeOverride 
    {
        get { Initialize(); return _preventEncryptionScopeOverride!; }
        set { Initialize(); _preventEncryptionScopeOverride!.Assign(value); }
    }
    private BicepValue<bool>? _preventEncryptionScopeOverride;

    /// <summary>
    /// Specifies whether data in the container may be accessed publicly and
    /// the level of access.
    /// </summary>
    public BicepValue<StoragePublicAccessType> PublicAccess 
    {
        get { Initialize(); return _publicAccess!; }
        set { Initialize(); _publicAccess!.Assign(value); }
    }
    private BicepValue<StoragePublicAccessType>? _publicAccess;

    /// <summary>
    /// Blob container deletion time.
    /// </summary>
    public BicepValue<DateTimeOffset> DeletedOn 
    {
        get { Initialize(); return _deletedOn!; }
    }
    private BicepValue<DateTimeOffset>? _deletedOn;

    /// <summary>
    /// Resource Etag.
    /// </summary>
    public BicepValue<ETag> ETag 
    {
        get { Initialize(); return _eTag!; }
    }
    private BicepValue<ETag>? _eTag;

    /// <summary>
    /// The hasImmutabilityPolicy public property is set to true by SRP if
    /// ImmutabilityPolicy has been created for this container. The
    /// hasImmutabilityPolicy public property is set to false by SRP if
    /// ImmutabilityPolicy has not been created for this container.
    /// </summary>
    public BicepValue<bool> HasImmutabilityPolicy 
    {
        get { Initialize(); return _hasImmutabilityPolicy!; }
    }
    private BicepValue<bool>? _hasImmutabilityPolicy;

    /// <summary>
    /// The hasLegalHold public property is set to true by SRP if there are at
    /// least one existing tag. The hasLegalHold public property is set to
    /// false by SRP if all existing legal hold tags are cleared out. There
    /// can be a maximum of 1000 blob containers with hasLegalHold=true for a
    /// given account.
    /// </summary>
    public BicepValue<bool> HasLegalHold 
    {
        get { Initialize(); return _hasLegalHold!; }
    }
    private BicepValue<bool>? _hasLegalHold;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// The ImmutabilityPolicy property of the container.
    /// </summary>
    public BlobContainerImmutabilityPolicy ImmutabilityPolicy 
    {
        get { Initialize(); return _immutabilityPolicy!; }
    }
    private BlobContainerImmutabilityPolicy? _immutabilityPolicy;

    /// <summary>
    /// Indicates whether the blob container was deleted.
    /// </summary>
    public BicepValue<bool> IsDeleted 
    {
        get { Initialize(); return _isDeleted!; }
    }
    private BicepValue<bool>? _isDeleted;

    /// <summary>
    /// Returns the date and time the container was last modified.
    /// </summary>
    public BicepValue<DateTimeOffset> LastModifiedOn 
    {
        get { Initialize(); return _lastModifiedOn!; }
    }
    private BicepValue<DateTimeOffset>? _lastModifiedOn;

    /// <summary>
    /// Specifies whether the lease on a container is of infinite or fixed
    /// duration, only when the container is leased.
    /// </summary>
    public BicepValue<StorageLeaseDurationType> LeaseDuration 
    {
        get { Initialize(); return _leaseDuration!; }
    }
    private BicepValue<StorageLeaseDurationType>? _leaseDuration;

    /// <summary>
    /// Lease state of the container.
    /// </summary>
    public BicepValue<StorageLeaseState> LeaseState 
    {
        get { Initialize(); return _leaseState!; }
    }
    private BicepValue<StorageLeaseState>? _leaseState;

    /// <summary>
    /// The lease status of the container.
    /// </summary>
    public BicepValue<StorageLeaseStatus> LeaseStatus 
    {
        get { Initialize(); return _leaseStatus!; }
    }
    private BicepValue<StorageLeaseStatus>? _leaseStatus;

    /// <summary>
    /// The LegalHold property of the container.
    /// </summary>
    public LegalHoldProperties LegalHold 
    {
        get { Initialize(); return _legalHold!; }
    }
    private LegalHoldProperties? _legalHold;

    /// <summary>
    /// Remaining retention days for soft deleted blob container.
    /// </summary>
    public BicepValue<int> RemainingRetentionDays 
    {
        get { Initialize(); return _remainingRetentionDays!; }
    }
    private BicepValue<int>? _remainingRetentionDays;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// The version of the deleted blob container.
    /// </summary>
    public BicepValue<string> Version 
    {
        get { Initialize(); return _version!; }
    }
    private BicepValue<string>? _version;

    /// <summary>
    /// Gets or sets a reference to the parent BlobService.
    /// </summary>
    public BlobService? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<BlobService>? _parent;

    /// <summary>
    /// Creates a new BlobContainer.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the BlobContainer resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the BlobContainer.</param>
    public BlobContainer(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Storage/storageAccounts/blobServices/containers", resourceVersion ?? "2024-01-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of BlobContainer.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _defaultEncryptionScope = DefineProperty<string>("DefaultEncryptionScope", ["properties", "defaultEncryptionScope"]);
        _enableNfsV3AllSquash = DefineProperty<bool>("EnableNfsV3AllSquash", ["properties", "enableNfsV3AllSquash"]);
        _enableNfsV3RootSquash = DefineProperty<bool>("EnableNfsV3RootSquash", ["properties", "enableNfsV3RootSquash"]);
        _immutableStorageWithVersioning = DefineModelProperty<ImmutableStorageWithVersioning>("ImmutableStorageWithVersioning", ["properties", "immutableStorageWithVersioning"]);
        _metadata = DefineDictionaryProperty<string>("Metadata", ["properties", "metadata"]);
        _preventEncryptionScopeOverride = DefineProperty<bool>("PreventEncryptionScopeOverride", ["properties", "denyEncryptionScopeOverride"]);
        _publicAccess = DefineProperty<StoragePublicAccessType>("PublicAccess", ["properties", "publicAccess"]);
        _deletedOn = DefineProperty<DateTimeOffset>("DeletedOn", ["properties", "deletedTime"], isOutput: true);
        _eTag = DefineProperty<ETag>("ETag", ["etag"], isOutput: true);
        _hasImmutabilityPolicy = DefineProperty<bool>("HasImmutabilityPolicy", ["properties", "hasImmutabilityPolicy"], isOutput: true);
        _hasLegalHold = DefineProperty<bool>("HasLegalHold", ["properties", "hasLegalHold"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _immutabilityPolicy = DefineModelProperty<BlobContainerImmutabilityPolicy>("ImmutabilityPolicy", ["properties", "immutabilityPolicy"], isOutput: true);
        _isDeleted = DefineProperty<bool>("IsDeleted", ["properties", "deleted"], isOutput: true);
        _lastModifiedOn = DefineProperty<DateTimeOffset>("LastModifiedOn", ["properties", "lastModifiedTime"], isOutput: true);
        _leaseDuration = DefineProperty<StorageLeaseDurationType>("LeaseDuration", ["properties", "leaseDuration"], isOutput: true);
        _leaseState = DefineProperty<StorageLeaseState>("LeaseState", ["properties", "leaseState"], isOutput: true);
        _leaseStatus = DefineProperty<StorageLeaseStatus>("LeaseStatus", ["properties", "leaseStatus"], isOutput: true);
        _legalHold = DefineModelProperty<LegalHoldProperties>("LegalHold", ["properties", "legalHold"], isOutput: true);
        _remainingRetentionDays = DefineProperty<int>("RemainingRetentionDays", ["properties", "remainingRetentionDays"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _version = DefineProperty<string>("Version", ["properties", "version"], isOutput: true);
        _parent = DefineResource<BlobService>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported BlobContainer resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-01-01.
        /// </summary>
        public static readonly string V2024_01_01 = "2024-01-01";

        /// <summary>
        /// 2023-05-01.
        /// </summary>
        public static readonly string V2023_05_01 = "2023-05-01";

        /// <summary>
        /// 2023-04-01.
        /// </summary>
        public static readonly string V2023_04_01 = "2023-04-01";

        /// <summary>
        /// 2023-01-01.
        /// </summary>
        public static readonly string V2023_01_01 = "2023-01-01";

        /// <summary>
        /// 2022-09-01.
        /// </summary>
        public static readonly string V2022_09_01 = "2022-09-01";

        /// <summary>
        /// 2022-05-01.
        /// </summary>
        public static readonly string V2022_05_01 = "2022-05-01";

        /// <summary>
        /// 2021-09-01.
        /// </summary>
        public static readonly string V2021_09_01 = "2021-09-01";

        /// <summary>
        /// 2021-08-01.
        /// </summary>
        public static readonly string V2021_08_01 = "2021-08-01";

        /// <summary>
        /// 2021-06-01.
        /// </summary>
        public static readonly string V2021_06_01 = "2021-06-01";

        /// <summary>
        /// 2021-05-01.
        /// </summary>
        public static readonly string V2021_05_01 = "2021-05-01";

        /// <summary>
        /// 2021-04-01.
        /// </summary>
        public static readonly string V2021_04_01 = "2021-04-01";

        /// <summary>
        /// 2021-02-01.
        /// </summary>
        public static readonly string V2021_02_01 = "2021-02-01";

        /// <summary>
        /// 2021-01-01.
        /// </summary>
        public static readonly string V2021_01_01 = "2021-01-01";

        /// <summary>
        /// 2019-06-01.
        /// </summary>
        public static readonly string V2019_06_01 = "2019-06-01";

        /// <summary>
        /// 2019-04-01.
        /// </summary>
        public static readonly string V2019_04_01 = "2019-04-01";

        /// <summary>
        /// 2018-11-01.
        /// </summary>
        public static readonly string V2018_11_01 = "2018-11-01";

        /// <summary>
        /// 2018-07-01.
        /// </summary>
        public static readonly string V2018_07_01 = "2018-07-01";

        /// <summary>
        /// 2018-02-01.
        /// </summary>
        public static readonly string V2018_02_01 = "2018-02-01";

        /// <summary>
        /// 2017-10-01.
        /// </summary>
        public static readonly string V2017_10_01 = "2017-10-01";

        /// <summary>
        /// 2017-06-01.
        /// </summary>
        public static readonly string V2017_06_01 = "2017-06-01";

        /// <summary>
        /// 2016-12-01.
        /// </summary>
        public static readonly string V2016_12_01 = "2016-12-01";

        /// <summary>
        /// 2016-05-01.
        /// </summary>
        public static readonly string V2016_05_01 = "2016-05-01";
    }

    /// <summary>
    /// Creates a reference to an existing BlobContainer.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the BlobContainer resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the BlobContainer.</param>
    /// <returns>The existing BlobContainer resource.</returns>
    public static BlobContainer FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };

    /// <summary>
    /// Get the requirements for naming this BlobContainer resource.
    /// </summary>
    /// <returns>Naming requirements.</returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override ResourceNameRequirements GetResourceNameRequirements() =>
        new(minLength: 3, maxLength: 63, validCharacters: ResourceNameCharacters.LowercaseLetters | ResourceNameCharacters.Numbers | ResourceNameCharacters.Hyphen);
}
