// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;
using System.ComponentModel;

namespace Azure.Provisioning.Sql;

/// <summary>
/// SyncGroup.
/// </summary>
public partial class SyncGroup : ProvisionableResource
{
    /// <summary>
    /// The name of the sync group.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Conflict logging retention period.
    /// </summary>
    public BicepValue<int> ConflictLoggingRetentionInDays 
    {
        get { Initialize(); return _conflictLoggingRetentionInDays!; }
        set { Initialize(); _conflictLoggingRetentionInDays!.Assign(value); }
    }
    private BicepValue<int>? _conflictLoggingRetentionInDays;

    /// <summary>
    /// Conflict resolution policy of the sync group.
    /// </summary>
    public BicepValue<SyncConflictResolutionPolicy> ConflictResolutionPolicy 
    {
        get { Initialize(); return _conflictResolutionPolicy!; }
        set { Initialize(); _conflictResolutionPolicy!.Assign(value); }
    }
    private BicepValue<SyncConflictResolutionPolicy>? _conflictResolutionPolicy;

    /// <summary>
    /// Password for the sync group hub database credential.
    /// </summary>
    public BicepValue<string> HubDatabasePassword 
    {
        get { Initialize(); return _hubDatabasePassword!; }
        set { Initialize(); _hubDatabasePassword!.Assign(value); }
    }
    private BicepValue<string>? _hubDatabasePassword;

    /// <summary>
    /// User name for the sync group hub database credential.
    /// </summary>
    public BicepValue<string> HubDatabaseUserName 
    {
        get { Initialize(); return _hubDatabaseUserName!; }
        set { Initialize(); _hubDatabaseUserName!.Assign(value); }
    }
    private BicepValue<string>? _hubDatabaseUserName;

    /// <summary>
    /// Sync interval of the sync group.
    /// </summary>
    public BicepValue<int> Interval 
    {
        get { Initialize(); return _interval!; }
        set { Initialize(); _interval!.Assign(value); }
    }
    private BicepValue<int>? _interval;

    /// <summary>
    /// If conflict logging is enabled.
    /// </summary>
    public BicepValue<bool> IsConflictLoggingEnabled 
    {
        get { Initialize(); return _isConflictLoggingEnabled!; }
        set { Initialize(); _isConflictLoggingEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isConflictLoggingEnabled;

    /// <summary>
    /// Sync schema of the sync group.
    /// </summary>
    public SyncGroupSchema Schema 
    {
        get { Initialize(); return _schema!; }
        set { Initialize(); AssignOrReplace(ref _schema, value); }
    }
    private SyncGroupSchema? _schema;

    /// <summary>
    /// The name and capacity of the SKU.
    /// </summary>
    public SqlSku Sku 
    {
        get { Initialize(); return _sku!; }
        set { Initialize(); AssignOrReplace(ref _sku, value); }
    }
    private SqlSku? _sku;

    /// <summary>
    /// ARM resource id of the sync database in the sync group.
    /// </summary>
    public BicepValue<ResourceIdentifier> SyncDatabaseId 
    {
        get { Initialize(); return _syncDatabaseId!; }
        set { Initialize(); _syncDatabaseId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _syncDatabaseId;

    /// <summary>
    /// If use private link connection is enabled.
    /// </summary>
    public BicepValue<bool> UsePrivateLinkConnection 
    {
        get { Initialize(); return _usePrivateLinkConnection!; }
        set { Initialize(); _usePrivateLinkConnection!.Assign(value); }
    }
    private BicepValue<bool>? _usePrivateLinkConnection;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Last sync time of the sync group.
    /// </summary>
    public BicepValue<DateTimeOffset> LastSyncOn 
    {
        get { Initialize(); return _lastSyncOn!; }
    }
    private BicepValue<DateTimeOffset>? _lastSyncOn;

    /// <summary>
    /// Private endpoint name of the sync group if use private link connection
    /// is enabled.
    /// </summary>
    public BicepValue<string> PrivateEndpointName 
    {
        get { Initialize(); return _privateEndpointName!; }
    }
    private BicepValue<string>? _privateEndpointName;

    /// <summary>
    /// Sync state of the sync group.
    /// </summary>
    public BicepValue<SyncGroupState> SyncState 
    {
        get { Initialize(); return _syncState!; }
    }
    private BicepValue<SyncGroupState>? _syncState;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent SqlDatabase.
    /// </summary>
    public SqlDatabase? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<SqlDatabase>? _parent;

    /// <summary>
    /// Creates a new SyncGroup.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SyncGroup resource.  This can be
    /// used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SyncGroup.</param>
    public SyncGroup(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Sql/servers/databases/syncGroups", resourceVersion ?? "2021-11-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SyncGroup.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _conflictLoggingRetentionInDays = DefineProperty<int>("ConflictLoggingRetentionInDays", ["properties", "conflictLoggingRetentionInDays"]);
        _conflictResolutionPolicy = DefineProperty<SyncConflictResolutionPolicy>("ConflictResolutionPolicy", ["properties", "conflictResolutionPolicy"]);
        _hubDatabasePassword = DefineProperty<string>("HubDatabasePassword", ["properties", "hubDatabasePassword"]);
        _hubDatabaseUserName = DefineProperty<string>("HubDatabaseUserName", ["properties", "hubDatabaseUserName"]);
        _interval = DefineProperty<int>("Interval", ["properties", "interval"]);
        _isConflictLoggingEnabled = DefineProperty<bool>("IsConflictLoggingEnabled", ["properties", "enableConflictLogging"]);
        _schema = DefineModelProperty<SyncGroupSchema>("Schema", ["properties", "schema"]);
        _sku = DefineModelProperty<SqlSku>("Sku", ["sku"]);
        _syncDatabaseId = DefineProperty<ResourceIdentifier>("SyncDatabaseId", ["properties", "syncDatabaseId"]);
        _usePrivateLinkConnection = DefineProperty<bool>("UsePrivateLinkConnection", ["properties", "usePrivateLinkConnection"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _lastSyncOn = DefineProperty<DateTimeOffset>("LastSyncOn", ["properties", "lastSyncTime"], isOutput: true);
        _privateEndpointName = DefineProperty<string>("PrivateEndpointName", ["properties", "privateEndpointName"], isOutput: true);
        _syncState = DefineProperty<SyncGroupState>("SyncState", ["properties", "syncState"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<SqlDatabase>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported SyncGroup resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2021-11-01.
        /// </summary>
        public static readonly string V2021_11_01 = "2021-11-01";
    }

    /// <summary>
    /// Creates a reference to an existing SyncGroup.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SyncGroup resource.  This can be
    /// used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SyncGroup.</param>
    /// <returns>The existing SyncGroup resource.</returns>
    public static SyncGroup FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };

    /// <summary>
    /// Get the requirements for naming this SyncGroup resource.
    /// </summary>
    /// <returns>Naming requirements.</returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override ResourceNameRequirements GetResourceNameRequirements() =>
        new(minLength: 1, maxLength: 150, validCharacters: ResourceNameCharacters.LowercaseLetters | ResourceNameCharacters.UppercaseLetters | ResourceNameCharacters.Numbers | ResourceNameCharacters.Hyphen | ResourceNameCharacters.Underscore);
}
