// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// SyncAgent.
/// </summary>
public partial class SyncAgent : ProvisionableResource
{
    /// <summary>
    /// The name of the sync agent.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// ARM resource id of the sync database in the sync agent.
    /// </summary>
    public BicepValue<ResourceIdentifier> SyncDatabaseId 
    {
        get { Initialize(); return _syncDatabaseId!; }
        set { Initialize(); _syncDatabaseId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _syncDatabaseId;

    /// <summary>
    /// Expiration time of the sync agent version.
    /// </summary>
    public BicepValue<DateTimeOffset> ExpireOn 
    {
        get { Initialize(); return _expireOn!; }
    }
    private BicepValue<DateTimeOffset>? _expireOn;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// If the sync agent version is up to date.
    /// </summary>
    public BicepValue<bool> IsUpToDate 
    {
        get { Initialize(); return _isUpToDate!; }
    }
    private BicepValue<bool>? _isUpToDate;

    /// <summary>
    /// Last alive time of the sync agent.
    /// </summary>
    public BicepValue<DateTimeOffset> LastAliveOn 
    {
        get { Initialize(); return _lastAliveOn!; }
    }
    private BicepValue<DateTimeOffset>? _lastAliveOn;

    /// <summary>
    /// State of the sync agent.
    /// </summary>
    public BicepValue<SyncAgentState> State 
    {
        get { Initialize(); return _state!; }
    }
    private BicepValue<SyncAgentState>? _state;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Version of the sync agent.
    /// </summary>
    public BicepValue<string> Version 
    {
        get { Initialize(); return _version!; }
    }
    private BicepValue<string>? _version;

    /// <summary>
    /// Gets or sets a reference to the parent SqlServer.
    /// </summary>
    public SqlServer? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<SqlServer>? _parent;

    /// <summary>
    /// Creates a new SyncAgent.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SyncAgent resource.  This can be
    /// used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SyncAgent.</param>
    public SyncAgent(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Sql/servers/syncAgents", resourceVersion ?? "2021-11-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SyncAgent.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _syncDatabaseId = DefineProperty<ResourceIdentifier>("SyncDatabaseId", ["properties", "syncDatabaseId"]);
        _expireOn = DefineProperty<DateTimeOffset>("ExpireOn", ["properties", "expiryTime"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _isUpToDate = DefineProperty<bool>("IsUpToDate", ["properties", "isUpToDate"], isOutput: true);
        _lastAliveOn = DefineProperty<DateTimeOffset>("LastAliveOn", ["properties", "lastAliveTime"], isOutput: true);
        _state = DefineProperty<SyncAgentState>("State", ["properties", "state"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _version = DefineProperty<string>("Version", ["properties", "version"], isOutput: true);
        _parent = DefineResource<SqlServer>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported SyncAgent resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2021-11-01.
        /// </summary>
        public static readonly string V2021_11_01 = "2021-11-01";
    }

    /// <summary>
    /// Creates a reference to an existing SyncAgent.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SyncAgent resource.  This can be
    /// used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SyncAgent.</param>
    /// <returns>The existing SyncAgent resource.</returns>
    public static SyncAgent FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
