// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// SqlServerVulnerabilityAssessment.
/// </summary>
public partial class SqlServerVulnerabilityAssessment : ProvisionableResource
{
    /// <summary>
    /// Gets the Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The recurring scans settings.
    /// </summary>
    public VulnerabilityAssessmentRecurringScansProperties RecurringScans 
    {
        get { Initialize(); return _recurringScans!; }
        set { Initialize(); AssignOrReplace(ref _recurringScans, value); }
    }
    private VulnerabilityAssessmentRecurringScansProperties? _recurringScans;

    /// <summary>
    /// Specifies the identifier key of the storage account for vulnerability
    /// assessment scan results. If &apos;StorageContainerSasKey&apos;
    /// isn&apos;t specified, storageAccountAccessKey is required. Applies
    /// only if the storage account is not behind a Vnet or a firewall.
    /// </summary>
    public BicepValue<string> StorageAccountAccessKey 
    {
        get { Initialize(); return _storageAccountAccessKey!; }
        set { Initialize(); _storageAccountAccessKey!.Assign(value); }
    }
    private BicepValue<string>? _storageAccountAccessKey;

    /// <summary>
    /// A blob storage container path to hold the scan results (e.g.
    /// https://myStorage.blob.core.windows.net/VaScans/).
    /// </summary>
    public BicepValue<string> StorageContainerPath 
    {
        get { Initialize(); return _storageContainerPath!; }
        set { Initialize(); _storageContainerPath!.Assign(value); }
    }
    private BicepValue<string>? _storageContainerPath;

    /// <summary>
    /// A shared access signature (SAS Key) that has write access to the blob
    /// container specified in &apos;storageContainerPath&apos; parameter. If
    /// &apos;storageAccountAccessKey&apos; isn&apos;t specified,
    /// StorageContainerSasKey is required. Applies only if the storage
    /// account is not behind a Vnet or a firewall.
    /// </summary>
    public BicepValue<string> StorageContainerSasKey 
    {
        get { Initialize(); return _storageContainerSasKey!; }
        set { Initialize(); _storageContainerSasKey!.Assign(value); }
    }
    private BicepValue<string>? _storageContainerSasKey;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent SqlServer.
    /// </summary>
    public SqlServer? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<SqlServer>? _parent;

    /// <summary>
    /// Creates a new SqlServerVulnerabilityAssessment.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SqlServerVulnerabilityAssessment
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SqlServerVulnerabilityAssessment.</param>
    public SqlServerVulnerabilityAssessment(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Sql/servers/vulnerabilityAssessments", resourceVersion ?? "2021-11-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// SqlServerVulnerabilityAssessment.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _recurringScans = DefineModelProperty<VulnerabilityAssessmentRecurringScansProperties>("RecurringScans", ["properties", "recurringScans"]);
        _storageAccountAccessKey = DefineProperty<string>("StorageAccountAccessKey", ["properties", "storageAccountAccessKey"]);
        _storageContainerPath = DefineProperty<string>("StorageContainerPath", ["properties", "storageContainerPath"]);
        _storageContainerSasKey = DefineProperty<string>("StorageContainerSasKey", ["properties", "storageContainerSasKey"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<SqlServer>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported SqlServerVulnerabilityAssessment resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2021-11-01.
        /// </summary>
        public static readonly string V2021_11_01 = "2021-11-01";
    }

    /// <summary>
    /// Creates a reference to an existing SqlServerVulnerabilityAssessment.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SqlServerVulnerabilityAssessment
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SqlServerVulnerabilityAssessment.</param>
    /// <returns>The existing SqlServerVulnerabilityAssessment resource.</returns>
    public static SqlServerVulnerabilityAssessment FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
