// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// SqlServerTrustGroup.
/// </summary>
public partial class SqlServerTrustGroup : ProvisionableResource
{
    /// <summary>
    /// The name of the server trust group.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Group members information for the server trust group.
    /// </summary>
    public BicepList<ServerTrustGroupServerInfo> GroupMembers 
    {
        get { Initialize(); return _groupMembers!; }
        set { Initialize(); _groupMembers!.Assign(value); }
    }
    private BicepList<ServerTrustGroupServerInfo>? _groupMembers;

    /// <summary>
    /// Trust scope of the server trust group.
    /// </summary>
    public BicepList<ServerTrustGroupPropertiesTrustScopesItem> TrustScopes 
    {
        get { Initialize(); return _trustScopes!; }
        set { Initialize(); _trustScopes!.Assign(value); }
    }
    private BicepList<ServerTrustGroupPropertiesTrustScopesItem>? _trustScopes;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new SqlServerTrustGroup.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SqlServerTrustGroup resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SqlServerTrustGroup.</param>
    public SqlServerTrustGroup(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Sql/locations/serverTrustGroups", resourceVersion ?? "2021-11-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SqlServerTrustGroup.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _groupMembers = DefineListProperty<ServerTrustGroupServerInfo>("GroupMembers", ["properties", "groupMembers"]);
        _trustScopes = DefineListProperty<ServerTrustGroupPropertiesTrustScopesItem>("TrustScopes", ["properties", "trustScopes"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }

    /// <summary>
    /// Supported SqlServerTrustGroup resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2021-11-01.
        /// </summary>
        public static readonly string V2021_11_01 = "2021-11-01";
    }

    /// <summary>
    /// Creates a reference to an existing SqlServerTrustGroup.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SqlServerTrustGroup resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SqlServerTrustGroup.</param>
    /// <returns>The existing SqlServerTrustGroup resource.</returns>
    public static SqlServerTrustGroup FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
