// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// SqlServerSqlVulnerabilityAssessmentBaseline.
/// </summary>
public partial class SqlServerSqlVulnerabilityAssessmentBaseline : ProvisionableResource
{
    /// <summary>
    /// Gets the Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The latest scan flag.
    /// </summary>
    public BicepValue<bool> IsLatestScan 
    {
        get { Initialize(); return _isLatestScan!; }
        set { Initialize(); _isLatestScan!.Assign(value); }
    }
    private BicepValue<bool>? _isLatestScan;

    /// <summary>
    /// The rule baseline result list.
    /// </summary>
    public BicepDictionary<BicepList<BicepList<string>>> Results 
    {
        get { Initialize(); return _results!; }
        set { Initialize(); _results!.Assign(value); }
    }
    private BicepDictionary<BicepList<BicepList<string>>>? _results;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent SqlServerSqlVulnerabilityAssessment.
    /// </summary>
    public SqlServerSqlVulnerabilityAssessment? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<SqlServerSqlVulnerabilityAssessment>? _parent;

    /// <summary>
    /// Creates a new SqlServerSqlVulnerabilityAssessmentBaseline.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the
    /// SqlServerSqlVulnerabilityAssessmentBaseline resource.  This can be
    /// used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SqlServerSqlVulnerabilityAssessmentBaseline.</param>
    public SqlServerSqlVulnerabilityAssessmentBaseline(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Sql/servers/sqlVulnerabilityAssessments/baselines", resourceVersion ?? "2021-11-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// SqlServerSqlVulnerabilityAssessmentBaseline.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _isLatestScan = DefineProperty<bool>("IsLatestScan", ["properties", "latestScan"]);
        _results = DefineDictionaryProperty<BicepList<BicepList<string>>>("Results", ["properties", "results"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<SqlServerSqlVulnerabilityAssessment>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported SqlServerSqlVulnerabilityAssessmentBaseline resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2021-11-01.
        /// </summary>
        public static readonly string V2021_11_01 = "2021-11-01";

        /// <summary>
        /// 2014-04-01.
        /// </summary>
        public static readonly string V2014_04_01 = "2014-04-01";

        /// <summary>
        /// 2014-01-01.
        /// </summary>
        public static readonly string V2014_01_01 = "2014-01-01";
    }

    /// <summary>
    /// Creates a reference to an existing
    /// SqlServerSqlVulnerabilityAssessmentBaseline.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the
    /// SqlServerSqlVulnerabilityAssessmentBaseline resource.  This can be
    /// used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SqlServerSqlVulnerabilityAssessmentBaseline.</param>
    /// <returns>The existing SqlServerSqlVulnerabilityAssessmentBaseline resource.</returns>
    public static SqlServerSqlVulnerabilityAssessmentBaseline FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
