// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// SqlServerKey.
/// </summary>
public partial class SqlServerKey : ProvisionableResource
{
    /// <summary>
    /// The name of the server key to be operated on (updated or created). The
    /// key name is required to be in the format of
    /// &apos;vault_key_version&apos;. For example, if the keyId is
    /// https://YourVaultName.vault.azure.net/keys/YourKeyName/YourKeyVersion,
    /// then the server key name should be formatted as:
    /// YourVaultName_YourKeyName_YourKeyVersion.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The server key type like &apos;ServiceManaged&apos;,
    /// &apos;AzureKeyVault&apos;.
    /// </summary>
    public BicepValue<SqlServerKeyType> ServerKeyType 
    {
        get { Initialize(); return _serverKeyType!; }
        set { Initialize(); _serverKeyType!.Assign(value); }
    }
    private BicepValue<SqlServerKeyType>? _serverKeyType;

    /// <summary>
    /// The URI of the server key. If the ServerKeyType is AzureKeyVault, then
    /// the URI is required.
    /// </summary>
    public BicepValue<Uri> Uri 
    {
        get { Initialize(); return _uri!; }
        set { Initialize(); _uri!.Assign(value); }
    }
    private BicepValue<Uri>? _uri;

    /// <summary>
    /// The server key creation date.
    /// </summary>
    public BicepValue<DateTimeOffset> CreatedOn 
    {
        get { Initialize(); return _createdOn!; }
    }
    private BicepValue<DateTimeOffset>? _createdOn;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Key auto rotation opt-in flag. Either true or false.
    /// </summary>
    public BicepValue<bool> IsAutoRotationEnabled 
    {
        get { Initialize(); return _isAutoRotationEnabled!; }
    }
    private BicepValue<bool>? _isAutoRotationEnabled;

    /// <summary>
    /// Kind of encryption protector. This is metadata used for the Azure
    /// portal experience.
    /// </summary>
    public BicepValue<string> Kind 
    {
        get { Initialize(); return _kind!; }
    }
    private BicepValue<string>? _kind;

    /// <summary>
    /// Resource location.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// Subregion of the server key.
    /// </summary>
    public BicepValue<string> Subregion 
    {
        get { Initialize(); return _subregion!; }
    }
    private BicepValue<string>? _subregion;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Thumbprint of the server key.
    /// </summary>
    public BicepValue<string> Thumbprint 
    {
        get { Initialize(); return _thumbprint!; }
    }
    private BicepValue<string>? _thumbprint;

    /// <summary>
    /// Gets or sets a reference to the parent SqlServer.
    /// </summary>
    public SqlServer? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<SqlServer>? _parent;

    /// <summary>
    /// Creates a new SqlServerKey.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SqlServerKey resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SqlServerKey.</param>
    public SqlServerKey(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Sql/servers/keys", resourceVersion ?? "2021-11-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SqlServerKey.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _serverKeyType = DefineProperty<SqlServerKeyType>("ServerKeyType", ["properties", "serverKeyType"]);
        _uri = DefineProperty<Uri>("Uri", ["properties", "uri"]);
        _createdOn = DefineProperty<DateTimeOffset>("CreatedOn", ["properties", "creationDate"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _isAutoRotationEnabled = DefineProperty<bool>("IsAutoRotationEnabled", ["properties", "autoRotationEnabled"], isOutput: true);
        _kind = DefineProperty<string>("Kind", ["kind"], isOutput: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isOutput: true);
        _subregion = DefineProperty<string>("Subregion", ["properties", "subregion"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _thumbprint = DefineProperty<string>("Thumbprint", ["properties", "thumbprint"], isOutput: true);
        _parent = DefineResource<SqlServer>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported SqlServerKey resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2021-11-01.
        /// </summary>
        public static readonly string V2021_11_01 = "2021-11-01";
    }

    /// <summary>
    /// Creates a reference to an existing SqlServerKey.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SqlServerKey resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SqlServerKey.</param>
    /// <returns>The existing SqlServerKey resource.</returns>
    public static SqlServerKey FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
