// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// SqlServerJobStep.
/// </summary>
public partial class SqlServerJobStep : ProvisionableResource
{
    /// <summary>
    /// The name of the job step.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The action payload of the job step.
    /// </summary>
    public JobStepAction Action 
    {
        get { Initialize(); return _action!; }
        set { Initialize(); AssignOrReplace(ref _action, value); }
    }
    private JobStepAction? _action;

    /// <summary>
    /// The resource ID of the job credential that will be used to connect to
    /// the targets.
    /// </summary>
    public BicepValue<string> Credential 
    {
        get { Initialize(); return _credential!; }
        set { Initialize(); _credential!.Assign(value); }
    }
    private BicepValue<string>? _credential;

    /// <summary>
    /// Execution options for the job step.
    /// </summary>
    public JobStepExecutionOptions ExecutionOptions 
    {
        get { Initialize(); return _executionOptions!; }
        set { Initialize(); AssignOrReplace(ref _executionOptions, value); }
    }
    private JobStepExecutionOptions? _executionOptions;

    /// <summary>
    /// Output destination properties of the job step.
    /// </summary>
    public JobStepOutput Output 
    {
        get { Initialize(); return _output!; }
        set { Initialize(); AssignOrReplace(ref _output, value); }
    }
    private JobStepOutput? _output;

    /// <summary>
    /// The job step&apos;s index within the job. If not specified when
    /// creating the job step, it will be created as the last step. If not
    /// specified when updating the job step, the step id is not modified.
    /// </summary>
    public BicepValue<int> StepId 
    {
        get { Initialize(); return _stepId!; }
        set { Initialize(); _stepId!.Assign(value); }
    }
    private BicepValue<int>? _stepId;

    /// <summary>
    /// The resource ID of the target group that the job step will be executed
    /// on.
    /// </summary>
    public BicepValue<string> TargetGroup 
    {
        get { Initialize(); return _targetGroup!; }
        set { Initialize(); _targetGroup!.Assign(value); }
    }
    private BicepValue<string>? _targetGroup;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent SqlServerJob.
    /// </summary>
    public SqlServerJob? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<SqlServerJob>? _parent;

    /// <summary>
    /// Creates a new SqlServerJobStep.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SqlServerJobStep resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SqlServerJobStep.</param>
    public SqlServerJobStep(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Sql/servers/jobAgents/jobs/steps", resourceVersion ?? "2021-11-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SqlServerJobStep.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _action = DefineModelProperty<JobStepAction>("Action", ["properties", "action"]);
        _credential = DefineProperty<string>("Credential", ["properties", "credential"]);
        _executionOptions = DefineModelProperty<JobStepExecutionOptions>("ExecutionOptions", ["properties", "executionOptions"]);
        _output = DefineModelProperty<JobStepOutput>("Output", ["properties", "output"]);
        _stepId = DefineProperty<int>("StepId", ["properties", "stepId"]);
        _targetGroup = DefineProperty<string>("TargetGroup", ["properties", "targetGroup"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<SqlServerJob>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported SqlServerJobStep resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2021-11-01.
        /// </summary>
        public static readonly string V2021_11_01 = "2021-11-01";
    }

    /// <summary>
    /// Creates a reference to an existing SqlServerJobStep.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SqlServerJobStep resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SqlServerJobStep.</param>
    /// <returns>The existing SqlServerJobStep resource.</returns>
    public static SqlServerJobStep FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
