// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// SqlServerJobExecution.
/// </summary>
public partial class SqlServerJobExecution : ProvisionableResource
{
    /// <summary>
    /// Gets the Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The time that the job execution was created.
    /// </summary>
    public BicepValue<DateTimeOffset> CreateOn 
    {
        get { Initialize(); return _createOn!; }
    }
    private BicepValue<DateTimeOffset>? _createOn;

    /// <summary>
    /// Number of times the job execution has been attempted.
    /// </summary>
    public BicepValue<int> CurrentAttempts 
    {
        get { Initialize(); return _currentAttempts!; }
    }
    private BicepValue<int>? _currentAttempts;

    /// <summary>
    /// Start time of the current attempt.
    /// </summary>
    public BicepValue<DateTimeOffset> CurrentAttemptStartOn 
    {
        get { Initialize(); return _currentAttemptStartOn!; }
    }
    private BicepValue<DateTimeOffset>? _currentAttemptStartOn;

    /// <summary>
    /// The time that the job execution completed.
    /// </summary>
    public BicepValue<DateTimeOffset> EndOn 
    {
        get { Initialize(); return _endOn!; }
    }
    private BicepValue<DateTimeOffset>? _endOn;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// The unique identifier of the job execution.
    /// </summary>
    public BicepValue<Guid> JobExecutionId 
    {
        get { Initialize(); return _jobExecutionId!; }
    }
    private BicepValue<Guid>? _jobExecutionId;

    /// <summary>
    /// The job version number.
    /// </summary>
    public BicepValue<int> JobVersion 
    {
        get { Initialize(); return _jobVersion!; }
    }
    private BicepValue<int>? _jobVersion;

    /// <summary>
    /// The last status or error message.
    /// </summary>
    public BicepValue<string> LastMessage 
    {
        get { Initialize(); return _lastMessage!; }
    }
    private BicepValue<string>? _lastMessage;

    /// <summary>
    /// The detailed state of the job execution.
    /// </summary>
    public BicepValue<JobExecutionLifecycle> Lifecycle 
    {
        get { Initialize(); return _lifecycle!; }
    }
    private BicepValue<JobExecutionLifecycle>? _lifecycle;

    /// <summary>
    /// The ARM provisioning state of the job execution.
    /// </summary>
    public BicepValue<JobExecutionProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<JobExecutionProvisioningState>? _provisioningState;

    /// <summary>
    /// The time that the job execution started.
    /// </summary>
    public BicepValue<DateTimeOffset> StartOn 
    {
        get { Initialize(); return _startOn!; }
    }
    private BicepValue<DateTimeOffset>? _startOn;

    /// <summary>
    /// The job step id.
    /// </summary>
    public BicepValue<int> StepId 
    {
        get { Initialize(); return _stepId!; }
    }
    private BicepValue<int>? _stepId;

    /// <summary>
    /// The job step name.
    /// </summary>
    public BicepValue<string> StepName 
    {
        get { Initialize(); return _stepName!; }
    }
    private BicepValue<string>? _stepName;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// The target that this execution is executed on.
    /// </summary>
    public JobExecutionTarget Target 
    {
        get { Initialize(); return _target!; }
    }
    private JobExecutionTarget? _target;

    /// <summary>
    /// Gets or sets a reference to the parent SqlServerJob.
    /// </summary>
    public SqlServerJob? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<SqlServerJob>? _parent;

    /// <summary>
    /// Creates a new SqlServerJobExecution.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SqlServerJobExecution resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SqlServerJobExecution.</param>
    public SqlServerJobExecution(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Sql/servers/jobAgents/jobs/executions", resourceVersion ?? "2021-11-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SqlServerJobExecution.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _createOn = DefineProperty<DateTimeOffset>("CreateOn", ["properties", "createTime"], isOutput: true);
        _currentAttempts = DefineProperty<int>("CurrentAttempts", ["properties", "currentAttempts"], isOutput: true);
        _currentAttemptStartOn = DefineProperty<DateTimeOffset>("CurrentAttemptStartOn", ["properties", "currentAttemptStartTime"], isOutput: true);
        _endOn = DefineProperty<DateTimeOffset>("EndOn", ["properties", "endTime"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _jobExecutionId = DefineProperty<Guid>("JobExecutionId", ["properties", "jobExecutionId"], isOutput: true);
        _jobVersion = DefineProperty<int>("JobVersion", ["properties", "jobVersion"], isOutput: true);
        _lastMessage = DefineProperty<string>("LastMessage", ["properties", "lastMessage"], isOutput: true);
        _lifecycle = DefineProperty<JobExecutionLifecycle>("Lifecycle", ["properties", "lifecycle"], isOutput: true);
        _provisioningState = DefineProperty<JobExecutionProvisioningState>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _startOn = DefineProperty<DateTimeOffset>("StartOn", ["properties", "startTime"], isOutput: true);
        _stepId = DefineProperty<int>("StepId", ["properties", "stepId"], isOutput: true);
        _stepName = DefineProperty<string>("StepName", ["properties", "stepName"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _target = DefineModelProperty<JobExecutionTarget>("Target", ["properties", "target"], isOutput: true);
        _parent = DefineResource<SqlServerJob>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported SqlServerJobExecution resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2021-11-01.
        /// </summary>
        public static readonly string V2021_11_01 = "2021-11-01";
    }

    /// <summary>
    /// Creates a reference to an existing SqlServerJobExecution.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SqlServerJobExecution resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SqlServerJobExecution.</param>
    /// <returns>The existing SqlServerJobExecution resource.</returns>
    public static SqlServerJobExecution FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
