// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// SqlServerJobCredential.
/// </summary>
public partial class SqlServerJobCredential : ProvisionableResource
{
    /// <summary>
    /// The name of the credential.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The credential password.
    /// </summary>
    public BicepValue<string> Password 
    {
        get { Initialize(); return _password!; }
        set { Initialize(); _password!.Assign(value); }
    }
    private BicepValue<string>? _password;

    /// <summary>
    /// The credential user name.
    /// </summary>
    public BicepValue<string> Username 
    {
        get { Initialize(); return _username!; }
        set { Initialize(); _username!.Assign(value); }
    }
    private BicepValue<string>? _username;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent SqlServerJobAgent.
    /// </summary>
    public SqlServerJobAgent? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<SqlServerJobAgent>? _parent;

    /// <summary>
    /// Creates a new SqlServerJobCredential.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SqlServerJobCredential resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SqlServerJobCredential.</param>
    public SqlServerJobCredential(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Sql/servers/jobAgents/credentials", resourceVersion ?? "2021-11-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SqlServerJobCredential.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _password = DefineProperty<string>("Password", ["properties", "password"]);
        _username = DefineProperty<string>("Username", ["properties", "username"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<SqlServerJobAgent>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported SqlServerJobCredential resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2021-11-01.
        /// </summary>
        public static readonly string V2021_11_01 = "2021-11-01";
    }

    /// <summary>
    /// Creates a reference to an existing SqlServerJobCredential.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SqlServerJobCredential resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SqlServerJobCredential.</param>
    /// <returns>The existing SqlServerJobCredential resource.</returns>
    public static SqlServerJobCredential FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
