// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// SqlServerDevOpsAuditingSetting.
/// </summary>
public partial class SqlServerDevOpsAuditingSetting : ProvisionableResource
{
    /// <summary>
    /// The name of the devops audit settings. This should always be Default.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Specifies whether DevOps audit events are sent to Azure Monitor.
    /// In order to send the events to Azure Monitor, specify
    /// &apos;State&apos; as &apos;Enabled&apos; and
    /// &apos;IsAzureMonitorTargetEnabled&apos; as true.
    /// When using REST API to configure DevOps
    /// audit, Diagnostic Settings with &apos;DevOpsOperationsAudit&apos;
    /// diagnostic logs category on the master database should be also
    /// created.                           Diagnostic Settings URI format:
    /// PUT
    /// https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/master/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
    /// For more information, see [Diagnostic
    /// Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)
    /// or [Diagnostic Settings
    /// PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
    /// </summary>
    public BicepValue<bool> IsAzureMonitorTargetEnabled 
    {
        get { Initialize(); return _isAzureMonitorTargetEnabled!; }
        set { Initialize(); _isAzureMonitorTargetEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isAzureMonitorTargetEnabled;

    /// <summary>
    /// Specifies whether Managed Identity is used to access blob storage.
    /// </summary>
    public BicepValue<bool> IsManagedIdentityInUse 
    {
        get { Initialize(); return _isManagedIdentityInUse!; }
        set { Initialize(); _isManagedIdentityInUse!.Assign(value); }
    }
    private BicepValue<bool>? _isManagedIdentityInUse;

    /// <summary>
    /// Specifies the state of the audit. If state is Enabled, storageEndpoint
    /// or isAzureMonitorTargetEnabled are required.
    /// </summary>
    public BicepValue<BlobAuditingPolicyState> State 
    {
        get { Initialize(); return _state!; }
        set { Initialize(); _state!.Assign(value); }
    }
    private BicepValue<BlobAuditingPolicyState>? _state;

    /// <summary>
    /// Specifies the identifier key of the auditing storage account.
    /// If state is Enabled and storageEndpoint is specified, not
    /// specifying the storageAccountAccessKey will use SQL server
    /// system-assigned managed identity to access the storage.
    /// Prerequisites for using managed identity authentication:
    /// 1. Assign SQL Server a system-assigned managed identity in
    /// Azure Active Directory (AAD).             2. Grant SQL Server identity
    /// access to the storage account by adding &apos;Storage Blob Data
    /// Contributor&apos; RBAC role to the server identity.             For
    /// more information, see [Auditing to storage using Managed Identity
    /// authentication](https://go.microsoft.com/fwlink/?linkid=2114355)
    /// </summary>
    public BicepValue<string> StorageAccountAccessKey 
    {
        get { Initialize(); return _storageAccountAccessKey!; }
        set { Initialize(); _storageAccountAccessKey!.Assign(value); }
    }
    private BicepValue<string>? _storageAccountAccessKey;

    /// <summary>
    /// Specifies the blob storage subscription Id.
    /// </summary>
    public BicepValue<Guid> StorageAccountSubscriptionId 
    {
        get { Initialize(); return _storageAccountSubscriptionId!; }
        set { Initialize(); _storageAccountSubscriptionId!.Assign(value); }
    }
    private BicepValue<Guid>? _storageAccountSubscriptionId;

    /// <summary>
    /// Specifies the blob storage endpoint (e.g.
    /// https://MyAccount.blob.core.windows.net). If state is Enabled,
    /// storageEndpoint or isAzureMonitorTargetEnabled is required.
    /// </summary>
    public BicepValue<string> StorageEndpoint 
    {
        get { Initialize(); return _storageEndpoint!; }
        set { Initialize(); _storageEndpoint!.Assign(value); }
    }
    private BicepValue<string>? _storageEndpoint;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent SqlServer.
    /// </summary>
    public SqlServer? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<SqlServer>? _parent;

    /// <summary>
    /// Creates a new SqlServerDevOpsAuditingSetting.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SqlServerDevOpsAuditingSetting
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SqlServerDevOpsAuditingSetting.</param>
    public SqlServerDevOpsAuditingSetting(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Sql/servers/devOpsAuditingSettings", resourceVersion ?? "2021-11-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// SqlServerDevOpsAuditingSetting.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _isAzureMonitorTargetEnabled = DefineProperty<bool>("IsAzureMonitorTargetEnabled", ["properties", "isAzureMonitorTargetEnabled"]);
        _isManagedIdentityInUse = DefineProperty<bool>("IsManagedIdentityInUse", ["properties", "isManagedIdentityInUse"]);
        _state = DefineProperty<BlobAuditingPolicyState>("State", ["properties", "state"]);
        _storageAccountAccessKey = DefineProperty<string>("StorageAccountAccessKey", ["properties", "storageAccountAccessKey"]);
        _storageAccountSubscriptionId = DefineProperty<Guid>("StorageAccountSubscriptionId", ["properties", "storageAccountSubscriptionId"]);
        _storageEndpoint = DefineProperty<string>("StorageEndpoint", ["properties", "storageEndpoint"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<SqlServer>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported SqlServerDevOpsAuditingSetting resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2021-11-01.
        /// </summary>
        public static readonly string V2021_11_01 = "2021-11-01";
    }

    /// <summary>
    /// Creates a reference to an existing SqlServerDevOpsAuditingSetting.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SqlServerDevOpsAuditingSetting
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SqlServerDevOpsAuditingSetting.</param>
    /// <returns>The existing SqlServerDevOpsAuditingSetting resource.</returns>
    public static SqlServerDevOpsAuditingSetting FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
