// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// SqlServerDatabaseRestorePoint.
/// </summary>
public partial class SqlServerDatabaseRestorePoint : ProvisionableResource
{
    /// <summary>
    /// Gets the Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The earliest time to which this database can be restored.
    /// </summary>
    public BicepValue<DateTimeOffset> EarliestRestoreOn 
    {
        get { Initialize(); return _earliestRestoreOn!; }
    }
    private BicepValue<DateTimeOffset>? _earliestRestoreOn;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Resource location.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// The time the backup was taken.
    /// </summary>
    public BicepValue<DateTimeOffset> RestorePointCreatedOn 
    {
        get { Initialize(); return _restorePointCreatedOn!; }
    }
    private BicepValue<DateTimeOffset>? _restorePointCreatedOn;

    /// <summary>
    /// The label of restore point for backup request by user.
    /// </summary>
    public BicepValue<string> RestorePointLabel 
    {
        get { Initialize(); return _restorePointLabel!; }
    }
    private BicepValue<string>? _restorePointLabel;

    /// <summary>
    /// The type of restore point.
    /// </summary>
    public BicepValue<RestorePointType> RestorePointType 
    {
        get { Initialize(); return _restorePointType!; }
    }
    private BicepValue<RestorePointType>? _restorePointType;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent SqlDatabase.
    /// </summary>
    public SqlDatabase? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<SqlDatabase>? _parent;

    /// <summary>
    /// Creates a new SqlServerDatabaseRestorePoint.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SqlServerDatabaseRestorePoint
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SqlServerDatabaseRestorePoint.</param>
    public SqlServerDatabaseRestorePoint(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Sql/servers/databases/restorePoints", resourceVersion ?? "2021-11-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// SqlServerDatabaseRestorePoint.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _earliestRestoreOn = DefineProperty<DateTimeOffset>("EarliestRestoreOn", ["properties", "earliestRestoreDate"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isOutput: true);
        _restorePointCreatedOn = DefineProperty<DateTimeOffset>("RestorePointCreatedOn", ["properties", "restorePointCreationDate"], isOutput: true);
        _restorePointLabel = DefineProperty<string>("RestorePointLabel", ["properties", "restorePointLabel"], isOutput: true);
        _restorePointType = DefineProperty<RestorePointType>("RestorePointType", ["properties", "restorePointType"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<SqlDatabase>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported SqlServerDatabaseRestorePoint resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2021-11-01.
        /// </summary>
        public static readonly string V2021_11_01 = "2021-11-01";

        /// <summary>
        /// 2015-01-01.
        /// </summary>
        public static readonly string V2015_01_01 = "2015-01-01";

        /// <summary>
        /// 2014-04-01.
        /// </summary>
        public static readonly string V2014_04_01 = "2014-04-01";

        /// <summary>
        /// 2014-01-01.
        /// </summary>
        public static readonly string V2014_01_01 = "2014-01-01";
    }

    /// <summary>
    /// Creates a reference to an existing SqlServerDatabaseRestorePoint.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SqlServerDatabaseRestorePoint
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SqlServerDatabaseRestorePoint.</param>
    /// <returns>The existing SqlServerDatabaseRestorePoint resource.</returns>
    public static SqlServerDatabaseRestorePoint FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
