// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Authorization;
using Azure.Provisioning.Expressions;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using Azure.Provisioning.Roles;
using System;
using System.ComponentModel;

namespace Azure.Provisioning.Sql;

/// <summary>
/// SqlServer.
/// </summary>
public partial class SqlServer : ProvisionableResource
{
    /// <summary>
    /// The name of the server.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets or sets the Location.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// Administrator username for the server. Once created it cannot be
    /// changed.
    /// </summary>
    public BicepValue<string> AdministratorLogin 
    {
        get { Initialize(); return _administratorLogin!; }
        set { Initialize(); _administratorLogin!.Assign(value); }
    }
    private BicepValue<string>? _administratorLogin;

    /// <summary>
    /// The administrator login password (required for server creation).
    /// </summary>
    public BicepValue<string> AdministratorLoginPassword 
    {
        get { Initialize(); return _administratorLoginPassword!; }
        set { Initialize(); _administratorLoginPassword!.Assign(value); }
    }
    private BicepValue<string>? _administratorLoginPassword;

    /// <summary>
    /// The Azure Active Directory administrator of the server. This can only
    /// be used at server create time. If used for server update, it will be
    /// ignored or it will result in an error. For updates individual APIs
    /// will need to be used.
    /// </summary>
    public ServerExternalAdministrator Administrators 
    {
        get { Initialize(); return _administrators!; }
        set { Initialize(); AssignOrReplace(ref _administrators, value); }
    }
    private ServerExternalAdministrator? _administrators;

    /// <summary>
    /// The Client id used for cross tenant CMK scenario.
    /// </summary>
    public BicepValue<Guid> FederatedClientId 
    {
        get { Initialize(); return _federatedClientId!; }
        set { Initialize(); _federatedClientId!.Assign(value); }
    }
    private BicepValue<Guid>? _federatedClientId;

    /// <summary>
    /// The Azure Active Directory identity of the server.
    /// </summary>
    public ManagedServiceIdentity Identity 
    {
        get { Initialize(); return _identity!; }
        set { Initialize(); AssignOrReplace(ref _identity, value); }
    }
    private ManagedServiceIdentity? _identity;

    /// <summary>
    /// Whether or not to enable IPv6 support for this server.  Value is
    /// optional but if passed in, must be &apos;Enabled&apos; or
    /// &apos;Disabled&apos;.
    /// </summary>
    public BicepValue<ServerNetworkAccessFlag> IsIPv6Enabled 
    {
        get { Initialize(); return _isIPv6Enabled!; }
        set { Initialize(); _isIPv6Enabled!.Assign(value); }
    }
    private BicepValue<ServerNetworkAccessFlag>? _isIPv6Enabled;

    /// <summary>
    /// A CMK URI of the key to use for encryption.
    /// </summary>
    public BicepValue<Uri> KeyId 
    {
        get { Initialize(); return _keyId!; }
        set { Initialize(); _keyId!.Assign(value); }
    }
    private BicepValue<Uri>? _keyId;

    /// <summary>
    /// Minimal TLS version. Allowed values: &apos;None&apos;, 1.0&apos;,
    /// &apos;1.1&apos;, &apos;1.2&apos;, &apos;1.3&apos;.
    /// </summary>
    public BicepValue<SqlMinimalTlsVersion> MinTlsVersion 
    {
        get { Initialize(); return _minTlsVersion!; }
        set { Initialize(); _minTlsVersion!.Assign(value); }
    }
    private BicepValue<SqlMinimalTlsVersion>? _minTlsVersion;

    /// <summary>
    /// The resource id of a user assigned identity to be used by default.
    /// </summary>
    public BicepValue<ResourceIdentifier> PrimaryUserAssignedIdentityId 
    {
        get { Initialize(); return _primaryUserAssignedIdentityId!; }
        set { Initialize(); _primaryUserAssignedIdentityId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _primaryUserAssignedIdentityId;

    /// <summary>
    /// Whether or not public endpoint access is allowed for this server.
    /// Value is optional but if passed in, must be &apos;Enabled&apos; or
    /// &apos;Disabled&apos; or &apos;SecuredByPerimeter&apos;.
    /// </summary>
    public BicepValue<ServerNetworkAccessFlag> PublicNetworkAccess 
    {
        get { Initialize(); return _publicNetworkAccess!; }
        set { Initialize(); _publicNetworkAccess!.Assign(value); }
    }
    private BicepValue<ServerNetworkAccessFlag>? _publicNetworkAccess;

    /// <summary>
    /// Whether or not to restrict outbound network access for this server.
    /// Value is optional but if passed in, must be &apos;Enabled&apos; or
    /// &apos;Disabled&apos;.
    /// </summary>
    public BicepValue<ServerNetworkAccessFlag> RestrictOutboundNetworkAccess 
    {
        get { Initialize(); return _restrictOutboundNetworkAccess!; }
        set { Initialize(); _restrictOutboundNetworkAccess!.Assign(value); }
    }
    private BicepValue<ServerNetworkAccessFlag>? _restrictOutboundNetworkAccess;

    /// <summary>
    /// Gets or sets the Tags.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// The version of the server.
    /// </summary>
    public BicepValue<string> Version 
    {
        get { Initialize(); return _version!; }
        set { Initialize(); _version!.Assign(value); }
    }
    private BicepValue<string>? _version;

    /// <summary>
    /// Status of external governance.
    /// </summary>
    public BicepValue<ExternalGovernanceStatus> ExternalGovernanceStatus 
    {
        get { Initialize(); return _externalGovernanceStatus!; }
    }
    private BicepValue<ExternalGovernanceStatus>? _externalGovernanceStatus;

    /// <summary>
    /// The fully qualified domain name of the server.
    /// </summary>
    public BicepValue<string> FullyQualifiedDomainName 
    {
        get { Initialize(); return _fullyQualifiedDomainName!; }
    }
    private BicepValue<string>? _fullyQualifiedDomainName;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Kind of sql server. This is metadata used for the Azure portal
    /// experience.
    /// </summary>
    public BicepValue<string> Kind 
    {
        get { Initialize(); return _kind!; }
    }
    private BicepValue<string>? _kind;

    /// <summary>
    /// List of private endpoint connections on a server.
    /// </summary>
    public BicepList<SqlServerPrivateEndpointConnection> PrivateEndpointConnections 
    {
        get { Initialize(); return _privateEndpointConnections!; }
    }
    private BicepList<SqlServerPrivateEndpointConnection>? _privateEndpointConnections;

    /// <summary>
    /// The state of the server.
    /// </summary>
    public BicepValue<string> State 
    {
        get { Initialize(); return _state!; }
    }
    private BicepValue<string>? _state;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Whether or not existing server has a workspace created and if it allows
    /// connection from workspace.
    /// </summary>
    public BicepValue<ServerWorkspaceFeature> WorkspaceFeature 
    {
        get { Initialize(); return _workspaceFeature!; }
    }
    private BicepValue<ServerWorkspaceFeature>? _workspaceFeature;

    /// <summary>
    /// Creates a new SqlServer.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SqlServer resource.  This can be
    /// used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SqlServer.</param>
    public SqlServer(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Sql/servers", resourceVersion ?? "2021-11-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SqlServer.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isRequired: true);
        _administratorLogin = DefineProperty<string>("AdministratorLogin", ["properties", "administratorLogin"]);
        _administratorLoginPassword = DefineProperty<string>("AdministratorLoginPassword", ["properties", "administratorLoginPassword"]);
        _administrators = DefineModelProperty<ServerExternalAdministrator>("Administrators", ["properties", "administrators"]);
        _federatedClientId = DefineProperty<Guid>("FederatedClientId", ["properties", "federatedClientId"]);
        _identity = DefineModelProperty<ManagedServiceIdentity>("Identity", ["identity"]);
        _isIPv6Enabled = DefineProperty<ServerNetworkAccessFlag>("IsIPv6Enabled", ["properties", "isIPv6Enabled"]);
        _keyId = DefineProperty<Uri>("KeyId", ["properties", "keyId"]);
        _minTlsVersion = DefineProperty<SqlMinimalTlsVersion>("MinTlsVersion", ["properties", "minimalTlsVersion"]);
        _primaryUserAssignedIdentityId = DefineProperty<ResourceIdentifier>("PrimaryUserAssignedIdentityId", ["properties", "primaryUserAssignedIdentityId"]);
        _publicNetworkAccess = DefineProperty<ServerNetworkAccessFlag>("PublicNetworkAccess", ["properties", "publicNetworkAccess"]);
        _restrictOutboundNetworkAccess = DefineProperty<ServerNetworkAccessFlag>("RestrictOutboundNetworkAccess", ["properties", "restrictOutboundNetworkAccess"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _version = DefineProperty<string>("Version", ["properties", "version"]);
        _externalGovernanceStatus = DefineProperty<ExternalGovernanceStatus>("ExternalGovernanceStatus", ["properties", "externalGovernanceStatus"], isOutput: true);
        _fullyQualifiedDomainName = DefineProperty<string>("FullyQualifiedDomainName", ["properties", "fullyQualifiedDomainName"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _kind = DefineProperty<string>("Kind", ["kind"], isOutput: true);
        _privateEndpointConnections = DefineListProperty<SqlServerPrivateEndpointConnection>("PrivateEndpointConnections", ["properties", "privateEndpointConnections"], isOutput: true);
        _state = DefineProperty<string>("State", ["properties", "state"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _workspaceFeature = DefineProperty<ServerWorkspaceFeature>("WorkspaceFeature", ["properties", "workspaceFeature"], isOutput: true);
    }

    /// <summary>
    /// Supported SqlServer resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2021-11-01.
        /// </summary>
        public static readonly string V2021_11_01 = "2021-11-01";

        /// <summary>
        /// 2014-04-01.
        /// </summary>
        public static readonly string V2014_04_01 = "2014-04-01";

        /// <summary>
        /// 2014-01-01.
        /// </summary>
        public static readonly string V2014_01_01 = "2014-01-01";
    }

    /// <summary>
    /// Creates a reference to an existing SqlServer.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SqlServer resource.  This can be
    /// used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SqlServer.</param>
    /// <returns>The existing SqlServer resource.</returns>
    public static SqlServer FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };

    /// <summary>
    /// Get the requirements for naming this SqlServer resource.
    /// </summary>
    /// <returns>Naming requirements.</returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override ResourceNameRequirements GetResourceNameRequirements() =>
        new(minLength: 1, maxLength: 63, validCharacters: ResourceNameCharacters.LowercaseLetters | ResourceNameCharacters.Numbers | ResourceNameCharacters.Hyphen);

    /// <summary>
    /// Creates a role assignment for a user-assigned identity that grants
    /// access to this SqlServer.
    /// </summary>
    /// <param name="role">The role to grant.</param>
    /// <param name="identity">The <see cref="UserAssignedIdentity"/>.</param>
    /// <returns>The <see cref="RoleAssignment"/>.</returns>
    public RoleAssignment CreateRoleAssignment(SqlBuiltInRole role, UserAssignedIdentity identity) =>
        new($"{BicepIdentifier}_{identity.BicepIdentifier}_{SqlBuiltInRole.GetBuiltInRoleName(role)}")
        {
            Name = BicepFunction.CreateGuid(Id, identity.PrincipalId, BicepFunction.GetSubscriptionResourceId("Microsoft.Authorization/roleDefinitions", role.ToString())),
            Scope = new IdentifierExpression(BicepIdentifier),
            PrincipalType = RoleManagementPrincipalType.ServicePrincipal,
            RoleDefinitionId = BicepFunction.GetSubscriptionResourceId("Microsoft.Authorization/roleDefinitions", role.ToString()),
            PrincipalId = identity.PrincipalId
        };

    /// <summary>
    /// Creates a role assignment for a principal that grants access to this
    /// SqlServer.
    /// </summary>
    /// <param name="role">The role to grant.</param>
    /// <param name="principalType">The type of the principal to assign to.</param>
    /// <param name="principalId">The principal to assign to.</param>
    /// <param name="bicepIdentifierSuffix">Optional role assignment identifier name suffix.</param>
    /// <returns>The <see cref="RoleAssignment"/>.</returns>
    public RoleAssignment CreateRoleAssignment(SqlBuiltInRole role, BicepValue<RoleManagementPrincipalType> principalType, BicepValue<Guid> principalId, string? bicepIdentifierSuffix = default) =>
        new($"{BicepIdentifier}_{SqlBuiltInRole.GetBuiltInRoleName(role)}{(bicepIdentifierSuffix is null ? "" : "_")}{bicepIdentifierSuffix}")
        {
            Name = BicepFunction.CreateGuid(Id, principalId, BicepFunction.GetSubscriptionResourceId("Microsoft.Authorization/roleDefinitions", role.ToString())),
            Scope = new IdentifierExpression(BicepIdentifier),
            PrincipalType = principalType,
            RoleDefinitionId = BicepFunction.GetSubscriptionResourceId("Microsoft.Authorization/roleDefinitions", role.ToString()),
            PrincipalId = principalId
        };
}
