// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// SqlDatabaseVulnerabilityAssessmentRuleBaseline.
/// </summary>
public partial class SqlDatabaseVulnerabilityAssessmentRuleBaseline : ProvisionableResource
{
    /// <summary>
    /// Gets the Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The rule baseline result.
    /// </summary>
    public BicepList<DatabaseVulnerabilityAssessmentRuleBaselineItem> BaselineResults 
    {
        get { Initialize(); return _baselineResults!; }
        set { Initialize(); _baselineResults!.Assign(value); }
    }
    private BicepList<DatabaseVulnerabilityAssessmentRuleBaselineItem>? _baselineResults;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new SqlDatabaseVulnerabilityAssessmentRuleBaseline.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the
    /// SqlDatabaseVulnerabilityAssessmentRuleBaseline resource.  This can be
    /// used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SqlDatabaseVulnerabilityAssessmentRuleBaseline.</param>
    public SqlDatabaseVulnerabilityAssessmentRuleBaseline(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Sql/servers/databases/vulnerabilityAssessments/rules/baselines", resourceVersion)
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// SqlDatabaseVulnerabilityAssessmentRuleBaseline.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _baselineResults = DefineListProperty<DatabaseVulnerabilityAssessmentRuleBaselineItem>("BaselineResults", ["properties", "baselineResults"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }

    /// <summary>
    /// Creates a reference to an existing
    /// SqlDatabaseVulnerabilityAssessmentRuleBaseline.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the
    /// SqlDatabaseVulnerabilityAssessmentRuleBaseline resource.  This can be
    /// used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SqlDatabaseVulnerabilityAssessmentRuleBaseline.</param>
    /// <returns>The existing SqlDatabaseVulnerabilityAssessmentRuleBaseline resource.</returns>
    public static SqlDatabaseVulnerabilityAssessmentRuleBaseline FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
