// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// SqlDatabaseSqlVulnerabilityAssessmentBaselineRule.
/// </summary>
public partial class SqlDatabaseSqlVulnerabilityAssessmentBaselineRule : ProvisionableResource
{
    /// <summary>
    /// Gets the Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The latest scan flag.
    /// </summary>
    public BicepValue<bool> IsLatestScan 
    {
        get { Initialize(); return _isLatestScan!; }
        set { Initialize(); _isLatestScan!.Assign(value); }
    }
    private BicepValue<bool>? _isLatestScan;

    /// <summary>
    /// The rule baseline result.
    /// </summary>
    public BicepList<BicepList<string>> Results 
    {
        get { Initialize(); return _results!; }
        set { Initialize(); _results!.Assign(value); }
    }
    private BicepList<BicepList<string>>? _results;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent SqlDatabaseSqlVulnerabilityAssessmentBaseline.
    /// </summary>
    public SqlDatabaseSqlVulnerabilityAssessmentBaseline? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<SqlDatabaseSqlVulnerabilityAssessmentBaseline>? _parent;

    /// <summary>
    /// Creates a new SqlDatabaseSqlVulnerabilityAssessmentBaselineRule.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the
    /// SqlDatabaseSqlVulnerabilityAssessmentBaselineRule resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SqlDatabaseSqlVulnerabilityAssessmentBaselineRule.</param>
    public SqlDatabaseSqlVulnerabilityAssessmentBaselineRule(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Sql/servers/databases/sqlVulnerabilityAssessments/baselines/rules", resourceVersion)
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// SqlDatabaseSqlVulnerabilityAssessmentBaselineRule.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _isLatestScan = DefineProperty<bool>("IsLatestScan", ["properties", "latestScan"]);
        _results = DefineListProperty<BicepList<string>>("Results", ["properties", "results"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<SqlDatabaseSqlVulnerabilityAssessmentBaseline>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Creates a reference to an existing
    /// SqlDatabaseSqlVulnerabilityAssessmentBaselineRule.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the
    /// SqlDatabaseSqlVulnerabilityAssessmentBaselineRule resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SqlDatabaseSqlVulnerabilityAssessmentBaselineRule.</param>
    /// <returns>The existing SqlDatabaseSqlVulnerabilityAssessmentBaselineRule resource.</returns>
    public static SqlDatabaseSqlVulnerabilityAssessmentBaselineRule FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
