// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// SqlDatabaseSqlVulnerabilityAssessmentBaseline.
/// </summary>
public partial class SqlDatabaseSqlVulnerabilityAssessmentBaseline : ProvisionableResource
{
    /// <summary>
    /// Gets the Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The latest scan flag.
    /// </summary>
    public BicepValue<bool> IsLatestScan 
    {
        get { Initialize(); return _isLatestScan!; }
        set { Initialize(); _isLatestScan!.Assign(value); }
    }
    private BicepValue<bool>? _isLatestScan;

    /// <summary>
    /// The rule baseline result list.
    /// </summary>
    public BicepDictionary<BicepList<BicepList<string>>> Results 
    {
        get { Initialize(); return _results!; }
        set { Initialize(); _results!.Assign(value); }
    }
    private BicepDictionary<BicepList<BicepList<string>>>? _results;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new SqlDatabaseSqlVulnerabilityAssessmentBaseline.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the
    /// SqlDatabaseSqlVulnerabilityAssessmentBaseline resource.  This can be
    /// used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SqlDatabaseSqlVulnerabilityAssessmentBaseline.</param>
    public SqlDatabaseSqlVulnerabilityAssessmentBaseline(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Sql/servers/databases/sqlVulnerabilityAssessments/baselines", resourceVersion)
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// SqlDatabaseSqlVulnerabilityAssessmentBaseline.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _isLatestScan = DefineProperty<bool>("IsLatestScan", ["properties", "latestScan"]);
        _results = DefineDictionaryProperty<BicepList<BicepList<string>>>("Results", ["properties", "results"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }

    /// <summary>
    /// Creates a reference to an existing
    /// SqlDatabaseSqlVulnerabilityAssessmentBaseline.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the
    /// SqlDatabaseSqlVulnerabilityAssessmentBaseline resource.  This can be
    /// used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SqlDatabaseSqlVulnerabilityAssessmentBaseline.</param>
    /// <returns>The existing SqlDatabaseSqlVulnerabilityAssessmentBaseline resource.</returns>
    public static SqlDatabaseSqlVulnerabilityAssessmentBaseline FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
