// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// SqlDatabaseSensitivityLabel.
/// </summary>
public partial class SqlDatabaseSensitivityLabel : ProvisionableResource
{
    /// <summary>
    /// Gets the Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The information type.
    /// </summary>
    public BicepValue<string> InformationType 
    {
        get { Initialize(); return _informationType!; }
        set { Initialize(); _informationType!.Assign(value); }
    }
    private BicepValue<string>? _informationType;

    /// <summary>
    /// The information type ID.
    /// </summary>
    public BicepValue<string> InformationTypeId 
    {
        get { Initialize(); return _informationTypeId!; }
        set { Initialize(); _informationTypeId!.Assign(value); }
    }
    private BicepValue<string>? _informationTypeId;

    /// <summary>
    /// The label ID.
    /// </summary>
    public BicepValue<string> LabelId 
    {
        get { Initialize(); return _labelId!; }
        set { Initialize(); _labelId!.Assign(value); }
    }
    private BicepValue<string>? _labelId;

    /// <summary>
    /// The label name.
    /// </summary>
    public BicepValue<string> LabelName 
    {
        get { Initialize(); return _labelName!; }
        set { Initialize(); _labelName!.Assign(value); }
    }
    private BicepValue<string>? _labelName;

    /// <summary>
    /// Gets or sets the rank.
    /// </summary>
    public BicepValue<SensitivityLabelRank> Rank 
    {
        get { Initialize(); return _rank!; }
        set { Initialize(); _rank!.Assign(value); }
    }
    private BicepValue<SensitivityLabelRank>? _rank;

    /// <summary>
    /// The column name.
    /// </summary>
    public BicepValue<string> ColumnName 
    {
        get { Initialize(); return _columnName!; }
    }
    private BicepValue<string>? _columnName;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Is sensitivity recommendation disabled. Applicable for recommended
    /// sensitivity label only. Specifies whether the sensitivity
    /// recommendation on this column is disabled (dismissed) or not.
    /// </summary>
    public BicepValue<bool> IsDisabled 
    {
        get { Initialize(); return _isDisabled!; }
    }
    private BicepValue<bool>? _isDisabled;

    /// <summary>
    /// Resource that manages the sensitivity label.
    /// </summary>
    public BicepValue<string> ManagedBy 
    {
        get { Initialize(); return _managedBy!; }
    }
    private BicepValue<string>? _managedBy;

    /// <summary>
    /// The schema name.
    /// </summary>
    public BicepValue<string> SchemaName 
    {
        get { Initialize(); return _schemaName!; }
    }
    private BicepValue<string>? _schemaName;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// The table name.
    /// </summary>
    public BicepValue<string> TableName 
    {
        get { Initialize(); return _tableName!; }
    }
    private BicepValue<string>? _tableName;

    /// <summary>
    /// Creates a new SqlDatabaseSensitivityLabel.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SqlDatabaseSensitivityLabel
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SqlDatabaseSensitivityLabel.</param>
    public SqlDatabaseSensitivityLabel(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Sql/servers/databases/schemas/tables/columns/sensitivityLabels", resourceVersion)
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SqlDatabaseSensitivityLabel.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _informationType = DefineProperty<string>("InformationType", ["properties", "informationType"]);
        _informationTypeId = DefineProperty<string>("InformationTypeId", ["properties", "informationTypeId"]);
        _labelId = DefineProperty<string>("LabelId", ["properties", "labelId"]);
        _labelName = DefineProperty<string>("LabelName", ["properties", "labelName"]);
        _rank = DefineProperty<SensitivityLabelRank>("Rank", ["properties", "rank"]);
        _columnName = DefineProperty<string>("ColumnName", ["properties", "columnName"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _isDisabled = DefineProperty<bool>("IsDisabled", ["properties", "isDisabled"], isOutput: true);
        _managedBy = DefineProperty<string>("ManagedBy", ["managedBy"], isOutput: true);
        _schemaName = DefineProperty<string>("SchemaName", ["properties", "schemaName"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _tableName = DefineProperty<string>("TableName", ["properties", "tableName"], isOutput: true);
    }

    /// <summary>
    /// Creates a reference to an existing SqlDatabaseSensitivityLabel.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SqlDatabaseSensitivityLabel
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SqlDatabaseSensitivityLabel.</param>
    /// <returns>The existing SqlDatabaseSensitivityLabel resource.</returns>
    public static SqlDatabaseSensitivityLabel FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
