// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;
using System.ComponentModel;

namespace Azure.Provisioning.Sql;

/// <summary>
/// SqlDatabase.
/// </summary>
public partial class SqlDatabase : ProvisionableResource
{
    /// <summary>
    /// The name of the database.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets or sets the Location.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// Time in minutes after which database is automatically paused. A value
    /// of -1 means that automatic pause is disabled.
    /// </summary>
    public BicepValue<int> AutoPauseDelay 
    {
        get { Initialize(); return _autoPauseDelay!; }
        set { Initialize(); _autoPauseDelay!.Assign(value); }
    }
    private BicepValue<int>? _autoPauseDelay;

    /// <summary>
    /// Specifies the availability zone the database is pinned to.
    /// </summary>
    public BicepValue<SqlAvailabilityZoneType> AvailabilityZone 
    {
        get { Initialize(); return _availabilityZone!; }
        set { Initialize(); _availabilityZone!.Assign(value); }
    }
    private BicepValue<SqlAvailabilityZoneType>? _availabilityZone;

    /// <summary>
    /// Collation of the metadata catalog.
    /// </summary>
    public BicepValue<CatalogCollationType> CatalogCollation 
    {
        get { Initialize(); return _catalogCollation!; }
        set { Initialize(); _catalogCollation!.Assign(value); }
    }
    private BicepValue<CatalogCollationType>? _catalogCollation;

    /// <summary>
    /// The collation of the database.
    /// </summary>
    public BicepValue<string> Collation 
    {
        get { Initialize(); return _collation!; }
        set { Initialize(); _collation!.Assign(value); }
    }
    private BicepValue<string>? _collation;

    /// <summary>
    /// Specifies the mode of database creation.
    /// Default: regular database creation.
    /// Copy: creates a database as a copy of an
    /// existing database. sourceDatabaseId must be specified as the resource
    /// ID of the source database.                           Secondary:
    /// creates a database as a secondary replica of an existing database.
    /// sourceDatabaseId must be specified as the resource ID of the existing
    /// primary database.                           PointInTimeRestore:
    /// Creates a database by restoring a point in time backup of an existing
    /// database. sourceDatabaseId must be specified as the resource ID of the
    /// existing database, and restorePointInTime must be specified.
    /// Recovery: Creates a database by restoring a
    /// geo-replicated backup. sourceDatabaseId must be specified as the
    /// recoverable database resource ID to restore.
    /// Restore: Creates a database by restoring a
    /// backup of a deleted database. sourceDatabaseId must be specified. If
    /// sourceDatabaseId is the database&apos;s original resource ID, then
    /// sourceDatabaseDeletionDate must be specified. Otherwise
    /// sourceDatabaseId must be the restorable dropped database resource ID
    /// and sourceDatabaseDeletionDate is ignored. restorePointInTime may also
    /// be specified to restore from an earlier point in time.
    /// RestoreLongTermRetentionBackup: Creates a
    /// database by restoring from a long term retention vault.
    /// recoveryServicesRecoveryPointResourceId must be specified as the
    /// recovery point resource ID.                           Copy, Secondary,
    /// and RestoreLongTermRetentionBackup are not supported for DataWarehouse
    /// edition.
    /// </summary>
    public BicepValue<SqlDatabaseCreateMode> CreateMode 
    {
        get { Initialize(); return _createMode!; }
        set { Initialize(); _createMode!.Assign(value); }
    }
    private BicepValue<SqlDatabaseCreateMode>? _createMode;

    /// <summary>
    /// The resource identifier of the elastic pool containing this database.
    /// </summary>
    public BicepValue<ResourceIdentifier> ElasticPoolId 
    {
        get { Initialize(); return _elasticPoolId!; }
        set { Initialize(); _elasticPoolId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _elasticPoolId;

    /// <summary>
    /// The azure key vault URI of the database if it&apos;s configured with
    /// per Database Customer Managed Keys.
    /// </summary>
    public BicepValue<string> EncryptionProtector 
    {
        get { Initialize(); return _encryptionProtector!; }
        set { Initialize(); _encryptionProtector!.Assign(value); }
    }
    private BicepValue<string>? _encryptionProtector;

    /// <summary>
    /// The flag to enable or disable auto rotation of database encryption
    /// protector AKV key.
    /// </summary>
    public BicepValue<bool> EncryptionProtectorAutoRotation 
    {
        get { Initialize(); return _encryptionProtectorAutoRotation!; }
        set { Initialize(); _encryptionProtectorAutoRotation!.Assign(value); }
    }
    private BicepValue<bool>? _encryptionProtectorAutoRotation;

    /// <summary>
    /// The Client id used for cross tenant per database CMK scenario.
    /// </summary>
    public BicepValue<Guid> FederatedClientId 
    {
        get { Initialize(); return _federatedClientId!; }
        set { Initialize(); _federatedClientId!.Assign(value); }
    }
    private BicepValue<Guid>? _federatedClientId;

    /// <summary>
    /// Specifies the behavior when monthly free limits are exhausted for the
    /// free database.                           AutoPause: The database will
    /// be auto paused upon exhaustion of free limits for remainder of the
    /// month.                           BillForUsage: The database will
    /// continue to be online upon exhaustion of free limits and any overage
    /// will be billed.
    /// </summary>
    public BicepValue<FreeLimitExhaustionBehavior> FreeLimitExhaustionBehavior 
    {
        get { Initialize(); return _freeLimitExhaustionBehavior!; }
        set { Initialize(); _freeLimitExhaustionBehavior!.Assign(value); }
    }
    private BicepValue<FreeLimitExhaustionBehavior>? _freeLimitExhaustionBehavior;

    /// <summary>
    /// The number of secondary replicas associated with the database that are
    /// used to provide high availability. Not applicable to a Hyperscale
    /// database within an elastic pool.
    /// </summary>
    public BicepValue<int> HighAvailabilityReplicaCount 
    {
        get { Initialize(); return _highAvailabilityReplicaCount!; }
        set { Initialize(); _highAvailabilityReplicaCount!.Assign(value); }
    }
    private BicepValue<int>? _highAvailabilityReplicaCount;

    /// <summary>
    /// The Azure Active Directory identity of the database.
    /// </summary>
    public DatabaseIdentity Identity 
    {
        get { Initialize(); return _identity!; }
        set { Initialize(); AssignOrReplace(ref _identity, value); }
    }
    private DatabaseIdentity? _identity;

    /// <summary>
    /// Whether or not this database is a ledger database, which means all
    /// tables in the database are ledger tables. Note: the value of this
    /// property cannot be changed after the database has been created.
    /// </summary>
    public BicepValue<bool> IsLedgerOn 
    {
        get { Initialize(); return _isLedgerOn!; }
        set { Initialize(); _isLedgerOn!.Assign(value); }
    }
    private BicepValue<bool>? _isLedgerOn;

    /// <summary>
    /// Whether or not this database is zone redundant, which means the
    /// replicas of this database will be spread across multiple availability
    /// zones.
    /// </summary>
    public BicepValue<bool> IsZoneRedundant 
    {
        get { Initialize(); return _isZoneRedundant!; }
        set { Initialize(); _isZoneRedundant!.Assign(value); }
    }
    private BicepValue<bool>? _isZoneRedundant;

    /// <summary>
    /// The resource ids of the user assigned identities to use.
    /// </summary>
    public BicepDictionary<SqlDatabaseKey> Keys 
    {
        get { Initialize(); return _keys!; }
        set { Initialize(); _keys!.Assign(value); }
    }
    private BicepDictionary<SqlDatabaseKey>? _keys;

    /// <summary>
    /// The license type to apply for this database. `LicenseIncluded` if you
    /// need a license, or `BasePrice` if you have a license and are eligible
    /// for the Azure Hybrid Benefit.
    /// </summary>
    public BicepValue<DatabaseLicenseType> LicenseType 
    {
        get { Initialize(); return _licenseType!; }
        set { Initialize(); _licenseType!.Assign(value); }
    }
    private BicepValue<DatabaseLicenseType>? _licenseType;

    /// <summary>
    /// The resource identifier of the long term retention backup associated
    /// with create operation of this database.
    /// </summary>
    public BicepValue<ResourceIdentifier> LongTermRetentionBackupResourceId 
    {
        get { Initialize(); return _longTermRetentionBackupResourceId!; }
        set { Initialize(); _longTermRetentionBackupResourceId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _longTermRetentionBackupResourceId;

    /// <summary>
    /// Maintenance configuration id assigned to the database. This
    /// configuration defines the period when the maintenance updates will
    /// occur.
    /// </summary>
    public BicepValue<ResourceIdentifier> MaintenanceConfigurationId 
    {
        get { Initialize(); return _maintenanceConfigurationId!; }
        set { Initialize(); _maintenanceConfigurationId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _maintenanceConfigurationId;

    /// <summary>
    /// Whether or not customer controlled manual cutover needs to be done
    /// during Update Database operation to Hyperscale tier.
    /// This property is only applicable when
    /// scaling database from Business Critical/General
    /// Purpose/Premium/Standard tier to Hyperscale tier.
    /// When manualCutover is specified, the scaling
    /// operation will wait for user input to trigger cutover to Hyperscale
    /// database.                           To trigger cutover, please provide
    /// &apos;performCutover&apos; parameter when the Scaling operation is in
    /// Waiting state.
    /// </summary>
    public BicepValue<bool> ManualCutover 
    {
        get { Initialize(); return _manualCutover!; }
        set { Initialize(); _manualCutover!.Assign(value); }
    }
    private BicepValue<bool>? _manualCutover;

    /// <summary>
    /// The max size of the database expressed in bytes.
    /// </summary>
    public BicepValue<long> MaxSizeBytes 
    {
        get { Initialize(); return _maxSizeBytes!; }
        set { Initialize(); _maxSizeBytes!.Assign(value); }
    }
    private BicepValue<long>? _maxSizeBytes;

    /// <summary>
    /// Minimal capacity that database will always have allocated, if not
    /// paused.
    /// </summary>
    public BicepValue<double> MinCapacity 
    {
        get { Initialize(); return _minCapacity!; }
        set { Initialize(); _minCapacity!.Assign(value); }
    }
    private BicepValue<double>? _minCapacity;

    /// <summary>
    /// To trigger customer controlled manual cutover during the wait state
    /// while Scaling operation is in progress.                           This
    /// property parameter is only applicable for scaling operations that are
    /// initiated along with &apos;manualCutover&apos; parameter.
    /// This property is only applicable when
    /// scaling database from Business Critical/General
    /// Purpose/Premium/Standard tier to Hyperscale tier is already in
    /// progress.                           When performCutover is specified,
    /// the scaling operation will trigger cutover and perform role-change to
    /// Hyperscale database.
    /// </summary>
    public BicepValue<bool> PerformCutover 
    {
        get { Initialize(); return _performCutover!; }
        set { Initialize(); _performCutover!.Assign(value); }
    }
    private BicepValue<bool>? _performCutover;

    /// <summary>
    /// Type of enclave requested on the database i.e. Default or VBS enclaves.
    /// </summary>
    public BicepValue<SqlAlwaysEncryptedEnclaveType> PreferredEnclaveType 
    {
        get { Initialize(); return _preferredEnclaveType!; }
        set { Initialize(); _preferredEnclaveType!.Assign(value); }
    }
    private BicepValue<SqlAlwaysEncryptedEnclaveType>? _preferredEnclaveType;

    /// <summary>
    /// The state of read-only routing. If enabled, connections that have
    /// application intent set to readonly in their connection string may be
    /// routed to a readonly secondary replica in the same region. Not
    /// applicable to a Hyperscale database within an elastic pool.
    /// </summary>
    public BicepValue<DatabaseReadScale> ReadScale 
    {
        get { Initialize(); return _readScale!; }
        set { Initialize(); _readScale!.Assign(value); }
    }
    private BicepValue<DatabaseReadScale>? _readScale;

    /// <summary>
    /// The resource identifier of the recoverable database associated with
    /// create operation of this database.
    /// </summary>
    public BicepValue<ResourceIdentifier> RecoverableDatabaseId 
    {
        get { Initialize(); return _recoverableDatabaseId!; }
        set { Initialize(); _recoverableDatabaseId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _recoverableDatabaseId;

    /// <summary>
    /// The resource identifier of the recovery point associated with create
    /// operation of this database.
    /// </summary>
    public BicepValue<ResourceIdentifier> RecoveryServicesRecoveryPointId 
    {
        get { Initialize(); return _recoveryServicesRecoveryPointId!; }
        set { Initialize(); _recoveryServicesRecoveryPointId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _recoveryServicesRecoveryPointId;

    /// <summary>
    /// The storage account type to be used to store backups for this database.
    /// </summary>
    public BicepValue<SqlBackupStorageRedundancy> RequestedBackupStorageRedundancy 
    {
        get { Initialize(); return _requestedBackupStorageRedundancy!; }
        set { Initialize(); _requestedBackupStorageRedundancy!.Assign(value); }
    }
    private BicepValue<SqlBackupStorageRedundancy>? _requestedBackupStorageRedundancy;

    /// <summary>
    /// The resource identifier of the restorable dropped database associated
    /// with create operation of this database.
    /// </summary>
    public BicepValue<ResourceIdentifier> RestorableDroppedDatabaseId 
    {
        get { Initialize(); return _restorableDroppedDatabaseId!; }
        set { Initialize(); _restorableDroppedDatabaseId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _restorableDroppedDatabaseId;

    /// <summary>
    /// Specifies the point in time (ISO8601 format) of the source database
    /// that will be restored to create the new database.
    /// </summary>
    public BicepValue<DateTimeOffset> RestorePointInTime 
    {
        get { Initialize(); return _restorePointInTime!; }
        set { Initialize(); _restorePointInTime!.Assign(value); }
    }
    private BicepValue<DateTimeOffset>? _restorePointInTime;

    /// <summary>
    /// The name of the sample schema to apply when creating this database.
    /// </summary>
    public BicepValue<SampleSchemaName> SampleName 
    {
        get { Initialize(); return _sampleName!; }
        set { Initialize(); _sampleName!.Assign(value); }
    }
    private BicepValue<SampleSchemaName>? _sampleName;

    /// <summary>
    /// The secondary type of the database if it is a secondary.  Valid values
    /// are Geo, Named and Standby.
    /// </summary>
    public BicepValue<SecondaryType> SecondaryType 
    {
        get { Initialize(); return _secondaryType!; }
        set { Initialize(); _secondaryType!.Assign(value); }
    }
    private BicepValue<SecondaryType>? _secondaryType;

    /// <summary>
    /// The database SKU.                           The list of SKUs may vary
    /// by region and support offer. To determine the SKUs (including the SKU
    /// name, tier/edition, family, and capacity) that are available to your
    /// subscription in an Azure region, use the `Capabilities_ListByLocation`
    /// REST API or one of the following commands:
    /// ```azurecli              az sql db
    /// list-editions -l &lt;location&gt; -o table              ````
    /// ```powershell
    /// Get-AzSqlServerServiceObjective -Location
    /// &lt;location&gt;              ````
    /// </summary>
    public SqlSku Sku 
    {
        get { Initialize(); return _sku!; }
        set { Initialize(); AssignOrReplace(ref _sku, value); }
    }
    private SqlSku? _sku;

    /// <summary>
    /// Specifies the time that the database was deleted.
    /// </summary>
    public BicepValue<DateTimeOffset> SourceDatabaseDeletedOn 
    {
        get { Initialize(); return _sourceDatabaseDeletedOn!; }
        set { Initialize(); _sourceDatabaseDeletedOn!.Assign(value); }
    }
    private BicepValue<DateTimeOffset>? _sourceDatabaseDeletedOn;

    /// <summary>
    /// The resource identifier of the source database associated with create
    /// operation of this database.
    /// </summary>
    public BicepValue<ResourceIdentifier> SourceDatabaseId 
    {
        get { Initialize(); return _sourceDatabaseId!; }
        set { Initialize(); _sourceDatabaseId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _sourceDatabaseId;

    /// <summary>
    /// The resource identifier of the source associated with the create
    /// operation of this database.                           This property is
    /// only supported for DataWarehouse edition and allows to restore across
    /// subscriptions.                           When sourceResourceId is
    /// specified, sourceDatabaseId, recoverableDatabaseId,
    /// restorableDroppedDatabaseId and sourceDatabaseDeletionDate must not be
    /// specified and CreateMode must be PointInTimeRestore, Restore or
    /// Recover.                           When createMode is
    /// PointInTimeRestore, sourceResourceId must be the resource ID of the
    /// existing database or existing sql pool, and restorePointInTime must be
    /// specified.                           When createMode is Restore,
    /// sourceResourceId must be the resource ID of restorable dropped
    /// database or restorable dropped sql pool.
    /// When createMode is Recover, sourceResourceId
    /// must be the resource ID of recoverable database or recoverable sql
    /// pool.                           When source subscription belongs to a
    /// different tenant than target subscription,
    /// “x-ms-authorization-auxiliary” header must contain authentication
    /// token for the source tenant. For more details about
    /// “x-ms-authorization-auxiliary” header see
    /// https://docs.microsoft.com/en-us/azure/azure-resource-manager/management/authenticate-multi-tenant
    /// </summary>
    public BicepValue<ResourceIdentifier> SourceResourceId 
    {
        get { Initialize(); return _sourceResourceId!; }
        set { Initialize(); _sourceResourceId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _sourceResourceId;

    /// <summary>
    /// Gets or sets the Tags.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// Whether or not the database uses free monthly limits. Allowed on one
    /// database in a subscription.
    /// </summary>
    public BicepValue<bool> UseFreeLimit 
    {
        get { Initialize(); return _useFreeLimit!; }
        set { Initialize(); _useFreeLimit!.Assign(value); }
    }
    private BicepValue<bool>? _useFreeLimit;

    /// <summary>
    /// The creation date of the database (ISO8601 format).
    /// </summary>
    public BicepValue<DateTimeOffset> CreatedOn 
    {
        get { Initialize(); return _createdOn!; }
    }
    private BicepValue<DateTimeOffset>? _createdOn;

    /// <summary>
    /// The storage account type used to store backups for this database.
    /// </summary>
    public BicepValue<SqlBackupStorageRedundancy> CurrentBackupStorageRedundancy 
    {
        get { Initialize(); return _currentBackupStorageRedundancy!; }
    }
    private BicepValue<SqlBackupStorageRedundancy>? _currentBackupStorageRedundancy;

    /// <summary>
    /// The current service level objective name of the database.
    /// </summary>
    public BicepValue<string> CurrentServiceObjectiveName 
    {
        get { Initialize(); return _currentServiceObjectiveName!; }
    }
    private BicepValue<string>? _currentServiceObjectiveName;

    /// <summary>
    /// The name and tier of the SKU.
    /// </summary>
    public SqlSku CurrentSku 
    {
        get { Initialize(); return _currentSku!; }
    }
    private SqlSku? _currentSku;

    /// <summary>
    /// The ID of the database.
    /// </summary>
    public BicepValue<Guid> DatabaseId 
    {
        get { Initialize(); return _databaseId!; }
    }
    private BicepValue<Guid>? _databaseId;

    /// <summary>
    /// The default secondary region for this database.
    /// </summary>
    public BicepValue<AzureLocation> DefaultSecondaryLocation 
    {
        get { Initialize(); return _defaultSecondaryLocation!; }
    }
    private BicepValue<AzureLocation>? _defaultSecondaryLocation;

    /// <summary>
    /// This records the earliest start date and time that restore is available
    /// for this database (ISO8601 format).
    /// </summary>
    public BicepValue<DateTimeOffset> EarliestRestoreOn 
    {
        get { Initialize(); return _earliestRestoreOn!; }
    }
    private BicepValue<DateTimeOffset>? _earliestRestoreOn;

    /// <summary>
    /// Failover Group resource identifier that this database belongs to.
    /// </summary>
    public BicepValue<ResourceIdentifier> FailoverGroupId 
    {
        get { Initialize(); return _failoverGroupId!; }
    }
    private BicepValue<ResourceIdentifier>? _failoverGroupId;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Infra encryption is enabled for this database.
    /// </summary>
    public BicepValue<bool> IsInfraEncryptionEnabled 
    {
        get { Initialize(); return _isInfraEncryptionEnabled!; }
    }
    private BicepValue<bool>? _isInfraEncryptionEnabled;

    /// <summary>
    /// Kind of database. This is metadata used for the Azure portal experience.
    /// </summary>
    public BicepValue<string> Kind 
    {
        get { Initialize(); return _kind!; }
    }
    private BicepValue<string>? _kind;

    /// <summary>
    /// Resource that manages the database.
    /// </summary>
    public BicepValue<string> ManagedBy 
    {
        get { Initialize(); return _managedBy!; }
    }
    private BicepValue<string>? _managedBy;

    /// <summary>
    /// The max log size for this database.
    /// </summary>
    public BicepValue<long> MaxLogSizeBytes 
    {
        get { Initialize(); return _maxLogSizeBytes!; }
    }
    private BicepValue<long>? _maxLogSizeBytes;

    /// <summary>
    /// The date when database was paused by user configuration or
    /// action(ISO8601 format). Null if the database is ready.
    /// </summary>
    public BicepValue<DateTimeOffset> PausedOn 
    {
        get { Initialize(); return _pausedOn!; }
    }
    private BicepValue<DateTimeOffset>? _pausedOn;

    /// <summary>
    /// The requested service level objective name of the database.
    /// </summary>
    public BicepValue<string> RequestedServiceObjectiveName 
    {
        get { Initialize(); return _requestedServiceObjectiveName!; }
    }
    private BicepValue<string>? _requestedServiceObjectiveName;

    /// <summary>
    /// The date when database was resumed by user action or database login
    /// (ISO8601 format). Null if the database is paused.
    /// </summary>
    public BicepValue<DateTimeOffset> ResumedOn 
    {
        get { Initialize(); return _resumedOn!; }
    }
    private BicepValue<DateTimeOffset>? _resumedOn;

    /// <summary>
    /// The status of the database.
    /// </summary>
    public BicepValue<SqlDatabaseStatus> Status 
    {
        get { Initialize(); return _status!; }
    }
    private BicepValue<SqlDatabaseStatus>? _status;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent SqlServer.
    /// </summary>
    public SqlServer? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<SqlServer>? _parent;

    /// <summary>
    /// Creates a new SqlDatabase.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SqlDatabase resource.  This can be
    /// used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SqlDatabase.</param>
    public SqlDatabase(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Sql/servers/databases", resourceVersion ?? "2021-11-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SqlDatabase.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isRequired: true);
        _autoPauseDelay = DefineProperty<int>("AutoPauseDelay", ["properties", "autoPauseDelay"]);
        _availabilityZone = DefineProperty<SqlAvailabilityZoneType>("AvailabilityZone", ["properties", "availabilityZone"]);
        _catalogCollation = DefineProperty<CatalogCollationType>("CatalogCollation", ["properties", "catalogCollation"]);
        _collation = DefineProperty<string>("Collation", ["properties", "collation"]);
        _createMode = DefineProperty<SqlDatabaseCreateMode>("CreateMode", ["properties", "createMode"]);
        _elasticPoolId = DefineProperty<ResourceIdentifier>("ElasticPoolId", ["properties", "elasticPoolId"]);
        _encryptionProtector = DefineProperty<string>("EncryptionProtector", ["properties", "encryptionProtector"]);
        _encryptionProtectorAutoRotation = DefineProperty<bool>("EncryptionProtectorAutoRotation", ["properties", "encryptionProtectorAutoRotation"]);
        _federatedClientId = DefineProperty<Guid>("FederatedClientId", ["properties", "federatedClientId"]);
        _freeLimitExhaustionBehavior = DefineProperty<FreeLimitExhaustionBehavior>("FreeLimitExhaustionBehavior", ["properties", "freeLimitExhaustionBehavior"]);
        _highAvailabilityReplicaCount = DefineProperty<int>("HighAvailabilityReplicaCount", ["properties", "highAvailabilityReplicaCount"]);
        _identity = DefineModelProperty<DatabaseIdentity>("Identity", ["identity"]);
        _isLedgerOn = DefineProperty<bool>("IsLedgerOn", ["properties", "isLedgerOn"]);
        _isZoneRedundant = DefineProperty<bool>("IsZoneRedundant", ["properties", "zoneRedundant"]);
        _keys = DefineDictionaryProperty<SqlDatabaseKey>("Keys", ["properties", "keys"]);
        _licenseType = DefineProperty<DatabaseLicenseType>("LicenseType", ["properties", "licenseType"]);
        _longTermRetentionBackupResourceId = DefineProperty<ResourceIdentifier>("LongTermRetentionBackupResourceId", ["properties", "longTermRetentionBackupResourceId"]);
        _maintenanceConfigurationId = DefineProperty<ResourceIdentifier>("MaintenanceConfigurationId", ["properties", "maintenanceConfigurationId"]);
        _manualCutover = DefineProperty<bool>("ManualCutover", ["properties", "manualCutover"]);
        _maxSizeBytes = DefineProperty<long>("MaxSizeBytes", ["properties", "maxSizeBytes"]);
        _minCapacity = DefineProperty<double>("MinCapacity", ["properties", "minCapacity"]);
        _performCutover = DefineProperty<bool>("PerformCutover", ["properties", "performCutover"]);
        _preferredEnclaveType = DefineProperty<SqlAlwaysEncryptedEnclaveType>("PreferredEnclaveType", ["properties", "preferredEnclaveType"]);
        _readScale = DefineProperty<DatabaseReadScale>("ReadScale", ["properties", "readScale"]);
        _recoverableDatabaseId = DefineProperty<ResourceIdentifier>("RecoverableDatabaseId", ["properties", "recoverableDatabaseId"]);
        _recoveryServicesRecoveryPointId = DefineProperty<ResourceIdentifier>("RecoveryServicesRecoveryPointId", ["properties", "recoveryServicesRecoveryPointId"]);
        _requestedBackupStorageRedundancy = DefineProperty<SqlBackupStorageRedundancy>("RequestedBackupStorageRedundancy", ["properties", "requestedBackupStorageRedundancy"]);
        _restorableDroppedDatabaseId = DefineProperty<ResourceIdentifier>("RestorableDroppedDatabaseId", ["properties", "restorableDroppedDatabaseId"]);
        _restorePointInTime = DefineProperty<DateTimeOffset>("RestorePointInTime", ["properties", "restorePointInTime"]);
        _sampleName = DefineProperty<SampleSchemaName>("SampleName", ["properties", "sampleName"]);
        _secondaryType = DefineProperty<SecondaryType>("SecondaryType", ["properties", "secondaryType"]);
        _sku = DefineModelProperty<SqlSku>("Sku", ["sku"]);
        _sourceDatabaseDeletedOn = DefineProperty<DateTimeOffset>("SourceDatabaseDeletedOn", ["properties", "sourceDatabaseDeletionDate"]);
        _sourceDatabaseId = DefineProperty<ResourceIdentifier>("SourceDatabaseId", ["properties", "sourceDatabaseId"]);
        _sourceResourceId = DefineProperty<ResourceIdentifier>("SourceResourceId", ["properties", "sourceResourceId"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _useFreeLimit = DefineProperty<bool>("UseFreeLimit", ["properties", "useFreeLimit"]);
        _createdOn = DefineProperty<DateTimeOffset>("CreatedOn", ["properties", "creationDate"], isOutput: true);
        _currentBackupStorageRedundancy = DefineProperty<SqlBackupStorageRedundancy>("CurrentBackupStorageRedundancy", ["properties", "currentBackupStorageRedundancy"], isOutput: true);
        _currentServiceObjectiveName = DefineProperty<string>("CurrentServiceObjectiveName", ["properties", "currentServiceObjectiveName"], isOutput: true);
        _currentSku = DefineModelProperty<SqlSku>("CurrentSku", ["properties", "currentSku"], isOutput: true);
        _databaseId = DefineProperty<Guid>("DatabaseId", ["properties", "databaseId"], isOutput: true);
        _defaultSecondaryLocation = DefineProperty<AzureLocation>("DefaultSecondaryLocation", ["properties", "defaultSecondaryLocation"], isOutput: true);
        _earliestRestoreOn = DefineProperty<DateTimeOffset>("EarliestRestoreOn", ["properties", "earliestRestoreDate"], isOutput: true);
        _failoverGroupId = DefineProperty<ResourceIdentifier>("FailoverGroupId", ["properties", "failoverGroupId"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _isInfraEncryptionEnabled = DefineProperty<bool>("IsInfraEncryptionEnabled", ["properties", "isInfraEncryptionEnabled"], isOutput: true);
        _kind = DefineProperty<string>("Kind", ["kind"], isOutput: true);
        _managedBy = DefineProperty<string>("ManagedBy", ["managedBy"], isOutput: true);
        _maxLogSizeBytes = DefineProperty<long>("MaxLogSizeBytes", ["properties", "maxLogSizeBytes"], isOutput: true);
        _pausedOn = DefineProperty<DateTimeOffset>("PausedOn", ["properties", "pausedDate"], isOutput: true);
        _requestedServiceObjectiveName = DefineProperty<string>("RequestedServiceObjectiveName", ["properties", "requestedServiceObjectiveName"], isOutput: true);
        _resumedOn = DefineProperty<DateTimeOffset>("ResumedOn", ["properties", "resumedDate"], isOutput: true);
        _status = DefineProperty<SqlDatabaseStatus>("Status", ["properties", "status"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<SqlServer>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported SqlDatabase resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2021-11-01.
        /// </summary>
        public static readonly string V2021_11_01 = "2021-11-01";

        /// <summary>
        /// 2015-01-01.
        /// </summary>
        public static readonly string V2015_01_01 = "2015-01-01";

        /// <summary>
        /// 2014-04-01.
        /// </summary>
        public static readonly string V2014_04_01 = "2014-04-01";

        /// <summary>
        /// 2014-01-01.
        /// </summary>
        public static readonly string V2014_01_01 = "2014-01-01";
    }

    /// <summary>
    /// Creates a reference to an existing SqlDatabase.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SqlDatabase resource.  This can be
    /// used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SqlDatabase.</param>
    /// <returns>The existing SqlDatabase resource.</returns>
    public static SqlDatabase FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };

    /// <summary>
    /// Get the requirements for naming this SqlDatabase resource.
    /// </summary>
    /// <returns>Naming requirements.</returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override ResourceNameRequirements GetResourceNameRequirements() =>
        new(minLength: 1, maxLength: 128, validCharacters: ResourceNameCharacters.LowercaseLetters | ResourceNameCharacters.UppercaseLetters | ResourceNameCharacters.Numbers | ResourceNameCharacters.Hyphen | ResourceNameCharacters.Underscore | ResourceNameCharacters.Period | ResourceNameCharacters.Parentheses);
}
