// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// Properties of a Vulnerability Assessment recurring scans.
/// </summary>
public partial class VulnerabilityAssessmentRecurringScansProperties : ProvisionableConstruct
{
    /// <summary>
    /// Recurring scans state.
    /// </summary>
    public BicepValue<bool> IsEnabled 
    {
        get { Initialize(); return _isEnabled!; }
        set { Initialize(); _isEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isEnabled;

    /// <summary>
    /// Specifies that the schedule scan notification will be is sent to the
    /// subscription administrators.
    /// </summary>
    public BicepValue<bool> EmailSubscriptionAdmins 
    {
        get { Initialize(); return _emailSubscriptionAdmins!; }
        set { Initialize(); _emailSubscriptionAdmins!.Assign(value); }
    }
    private BicepValue<bool>? _emailSubscriptionAdmins;

    /// <summary>
    /// Specifies an array of e-mail addresses to which the scan notification
    /// is sent.
    /// </summary>
    public BicepList<string> Emails 
    {
        get { Initialize(); return _emails!; }
        set { Initialize(); _emails!.Assign(value); }
    }
    private BicepList<string>? _emails;

    /// <summary>
    /// Creates a new VulnerabilityAssessmentRecurringScansProperties.
    /// </summary>
    public VulnerabilityAssessmentRecurringScansProperties()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// VulnerabilityAssessmentRecurringScansProperties.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _isEnabled = DefineProperty<bool>("IsEnabled", ["isEnabled"]);
        _emailSubscriptionAdmins = DefineProperty<bool>("EmailSubscriptionAdmins", ["emailSubscriptionAdmins"]);
        _emails = DefineListProperty<string>("Emails", ["emails"]);
    }
}
