// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// Properties of table in sync group schema.
/// </summary>
public partial class SyncGroupSchemaTable : ProvisionableConstruct
{
    /// <summary>
    /// List of columns in sync group schema.
    /// </summary>
    public BicepList<SyncGroupSchemaTableColumn> Columns 
    {
        get { Initialize(); return _columns!; }
        set { Initialize(); _columns!.Assign(value); }
    }
    private BicepList<SyncGroupSchemaTableColumn>? _columns;

    /// <summary>
    /// Quoted name of sync group schema table.
    /// </summary>
    public BicepValue<string> QuotedName 
    {
        get { Initialize(); return _quotedName!; }
        set { Initialize(); _quotedName!.Assign(value); }
    }
    private BicepValue<string>? _quotedName;

    /// <summary>
    /// Creates a new SyncGroupSchemaTable.
    /// </summary>
    public SyncGroupSchemaTable()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SyncGroupSchemaTable.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _columns = DefineListProperty<SyncGroupSchemaTableColumn>("Columns", ["columns"]);
        _quotedName = DefineProperty<string>("QuotedName", ["quotedName"]);
    }
}
