// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// Properties of sync group schema.
/// </summary>
public partial class SyncGroupSchema : ProvisionableConstruct
{
    /// <summary>
    /// List of tables in sync group schema.
    /// </summary>
    public BicepList<SyncGroupSchemaTable> Tables 
    {
        get { Initialize(); return _tables!; }
        set { Initialize(); _tables!.Assign(value); }
    }
    private BicepList<SyncGroupSchemaTable>? _tables;

    /// <summary>
    /// Name of master sync member where the schema is from.
    /// </summary>
    public BicepValue<string> MasterSyncMemberName 
    {
        get { Initialize(); return _masterSyncMemberName!; }
        set { Initialize(); _masterSyncMemberName!.Assign(value); }
    }
    private BicepValue<string>? _masterSyncMemberName;

    /// <summary>
    /// Creates a new SyncGroupSchema.
    /// </summary>
    public SyncGroupSchema()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SyncGroupSchema.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _tables = DefineListProperty<SyncGroupSchemaTable>("Tables", ["tables"]);
        _masterSyncMemberName = DefineProperty<string>("MasterSyncMemberName", ["masterSyncMemberName"]);
    }
}
