// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// The managed instance&apos;s service principal configuration for a resource.
/// </summary>
public partial class SqlServicePrincipal : ProvisionableConstruct
{
    /// <summary>
    /// The Azure Active Directory application object id.
    /// </summary>
    public BicepValue<Guid> PrincipalId 
    {
        get { Initialize(); return _principalId!; }
    }
    private BicepValue<Guid>? _principalId;

    /// <summary>
    /// The Azure Active Directory application client id.
    /// </summary>
    public BicepValue<Guid> ClientId 
    {
        get { Initialize(); return _clientId!; }
    }
    private BicepValue<Guid>? _clientId;

    /// <summary>
    /// The Azure Active Directory tenant id.
    /// </summary>
    public BicepValue<Guid> TenantId 
    {
        get { Initialize(); return _tenantId!; }
    }
    private BicepValue<Guid>? _tenantId;

    /// <summary>
    /// Service principal type.
    /// </summary>
    public BicepValue<SqlServicePrincipalType> PrincipalType 
    {
        get { Initialize(); return _principalType!; }
        set { Initialize(); _principalType!.Assign(value); }
    }
    private BicepValue<SqlServicePrincipalType>? _principalType;

    /// <summary>
    /// Creates a new SqlServicePrincipal.
    /// </summary>
    public SqlServicePrincipal()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SqlServicePrincipal.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _principalId = DefineProperty<Guid>("PrincipalId", ["principalId"], isOutput: true);
        _clientId = DefineProperty<Guid>("ClientId", ["clientId"], isOutput: true);
        _tenantId = DefineProperty<Guid>("TenantId", ["tenantId"], isOutput: true);
        _principalType = DefineProperty<SqlServicePrincipalType>("PrincipalType", ["type"]);
    }
}
