// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// A private endpoint connection under a server.
/// </summary>
public partial class SqlServerPrivateEndpointConnection : ProvisionableConstruct
{
    /// <summary>
    /// Resource ID.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Private endpoint connection properties.
    /// </summary>
    public ServerPrivateEndpointConnectionProperties Properties 
    {
        get { Initialize(); return _properties!; }
    }
    private ServerPrivateEndpointConnectionProperties? _properties;

    /// <summary>
    /// Creates a new SqlServerPrivateEndpointConnection.
    /// </summary>
    public SqlServerPrivateEndpointConnection()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// SqlServerPrivateEndpointConnection.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _properties = DefineModelProperty<ServerPrivateEndpointConnectionProperties>("Properties", ["properties"], isOutput: true);
    }
}
