// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// Scheduling properties of a job.
/// </summary>
public partial class SqlServerJobSchedule : ProvisionableConstruct
{
    /// <summary>
    /// Schedule start time.
    /// </summary>
    public BicepValue<DateTimeOffset> StartOn 
    {
        get { Initialize(); return _startOn!; }
        set { Initialize(); _startOn!.Assign(value); }
    }
    private BicepValue<DateTimeOffset>? _startOn;

    /// <summary>
    /// Schedule end time.
    /// </summary>
    public BicepValue<DateTimeOffset> EndOn 
    {
        get { Initialize(); return _endOn!; }
        set { Initialize(); _endOn!.Assign(value); }
    }
    private BicepValue<DateTimeOffset>? _endOn;

    /// <summary>
    /// Schedule interval type.
    /// </summary>
    public BicepValue<SqlServerJobScheduleType> ScheduleType 
    {
        get { Initialize(); return _scheduleType!; }
        set { Initialize(); _scheduleType!.Assign(value); }
    }
    private BicepValue<SqlServerJobScheduleType>? _scheduleType;

    /// <summary>
    /// Whether or not the schedule is enabled.
    /// </summary>
    public BicepValue<bool> IsEnabled 
    {
        get { Initialize(); return _isEnabled!; }
        set { Initialize(); _isEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isEnabled;

    /// <summary>
    /// Value of the schedule&apos;s recurring interval, if the ScheduleType is
    /// recurring. ISO8601 duration format.
    /// </summary>
    public BicepValue<TimeSpan> Interval 
    {
        get { Initialize(); return _interval!; }
        set { Initialize(); _interval!.Assign(value); }
    }
    private BicepValue<TimeSpan>? _interval;

    /// <summary>
    /// Creates a new SqlServerJobSchedule.
    /// </summary>
    public SqlServerJobSchedule()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SqlServerJobSchedule.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _startOn = DefineProperty<DateTimeOffset>("StartOn", ["startTime"]);
        _endOn = DefineProperty<DateTimeOffset>("EndOn", ["endTime"]);
        _scheduleType = DefineProperty<SqlServerJobScheduleType>("ScheduleType", ["type"]);
        _isEnabled = DefineProperty<bool>("IsEnabled", ["enabled"]);
        _interval = DefineProperty<TimeSpan>("Interval", ["interval"], format: "P");
    }
}
