// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// The SqlPrivateLinkServiceConnectionStateProperty.
/// </summary>
public partial class SqlPrivateLinkServiceConnectionStateProperty : ProvisionableConstruct
{
    /// <summary>
    /// The private link service connection status.
    /// </summary>
    public BicepValue<SqlPrivateLinkServiceConnectionStatus> Status 
    {
        get { Initialize(); return _status!; }
        set { Initialize(); _status!.Assign(value); }
    }
    private BicepValue<SqlPrivateLinkServiceConnectionStatus>? _status;

    /// <summary>
    /// The private link service connection description.
    /// </summary>
    public BicepValue<string> Description 
    {
        get { Initialize(); return _description!; }
        set { Initialize(); _description!.Assign(value); }
    }
    private BicepValue<string>? _description;

    /// <summary>
    /// The actions required for private link service connection.
    /// </summary>
    public BicepValue<SqlPrivateLinkServiceConnectionActionsRequired> ActionsRequired 
    {
        get { Initialize(); return _actionsRequired!; }
    }
    private BicepValue<SqlPrivateLinkServiceConnectionActionsRequired>? _actionsRequired;

    /// <summary>
    /// Creates a new SqlPrivateLinkServiceConnectionStateProperty.
    /// </summary>
    public SqlPrivateLinkServiceConnectionStateProperty()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// SqlPrivateLinkServiceConnectionStateProperty.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _status = DefineProperty<SqlPrivateLinkServiceConnectionStatus>("Status", ["status"]);
        _description = DefineProperty<string>("Description", ["description"]);
        _actionsRequired = DefineProperty<SqlPrivateLinkServiceConnectionActionsRequired>("ActionsRequired", ["actionsRequired"], isOutput: true);
    }
}
