// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// Database level key used for encryption at rest.
/// </summary>
public partial class SqlDatabaseKey : ProvisionableConstruct
{
    /// <summary>
    /// The database key type. Only supported value is
    /// &apos;AzureKeyVault&apos;.
    /// </summary>
    public BicepValue<SqlDatabaseKeyType> KeyType 
    {
        get { Initialize(); return _keyType!; }
    }
    private BicepValue<SqlDatabaseKeyType>? _keyType;

    /// <summary>
    /// Thumbprint of the database key.
    /// </summary>
    public BicepValue<string> Thumbprint 
    {
        get { Initialize(); return _thumbprint!; }
    }
    private BicepValue<string>? _thumbprint;

    /// <summary>
    /// The database key creation date.
    /// </summary>
    public BicepValue<DateTimeOffset> CreatedOn 
    {
        get { Initialize(); return _createdOn!; }
    }
    private BicepValue<DateTimeOffset>? _createdOn;

    /// <summary>
    /// Subregion of the server key.
    /// </summary>
    public BicepValue<string> Subregion 
    {
        get { Initialize(); return _subregion!; }
    }
    private BicepValue<string>? _subregion;

    /// <summary>
    /// Creates a new SqlDatabaseKey.
    /// </summary>
    public SqlDatabaseKey()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SqlDatabaseKey.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _keyType = DefineProperty<SqlDatabaseKeyType>("KeyType", ["type"], isOutput: true);
        _thumbprint = DefineProperty<string>("Thumbprint", ["thumbprint"], isOutput: true);
        _createdOn = DefineProperty<DateTimeOffset>("CreatedOn", ["creationDate"], isOutput: true);
        _subregion = DefineProperty<string>("Subregion", ["subregion"], isOutput: true);
    }
}
