// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

namespace Azure.Provisioning.Sql;

/// <summary>
/// Specifies the mode of database creation.                           Default:
/// regular database creation.                           Copy: creates a
/// database as a copy of an existing database. sourceDatabaseId must be
/// specified as the resource ID of the source database.
/// Secondary: creates a database as a secondary
/// replica of an existing database. sourceDatabaseId must be specified as the
/// resource ID of the existing primary database.
/// PointInTimeRestore: Creates a database by
/// restoring a point in time backup of an existing database. sourceDatabaseId
/// must be specified as the resource ID of the existing database, and
/// restorePointInTime must be specified.                           Recovery:
/// Creates a database by restoring a geo-replicated backup. sourceDatabaseId
/// must be specified as the recoverable database resource ID to restore.
/// Restore: Creates a database by restoring a
/// backup of a deleted database. sourceDatabaseId must be specified. If
/// sourceDatabaseId is the database&apos;s original resource ID, then
/// sourceDatabaseDeletionDate must be specified. Otherwise sourceDatabaseId
/// must be the restorable dropped database resource ID and
/// sourceDatabaseDeletionDate is ignored. restorePointInTime may also be
/// specified to restore from an earlier point in time.
/// RestoreLongTermRetentionBackup: Creates a
/// database by restoring from a long term retention vault.
/// recoveryServicesRecoveryPointResourceId must be specified as the recovery
/// point resource ID.                           Copy, Secondary, and
/// RestoreLongTermRetentionBackup are not supported for DataWarehouse edition.
/// </summary>
public enum SqlDatabaseCreateMode
{
    /// <summary>
    /// Default.
    /// </summary>
    Default,

    /// <summary>
    /// Copy.
    /// </summary>
    Copy,

    /// <summary>
    /// Secondary.
    /// </summary>
    Secondary,

    /// <summary>
    /// PointInTimeRestore.
    /// </summary>
    PointInTimeRestore,

    /// <summary>
    /// Restore.
    /// </summary>
    Restore,

    /// <summary>
    /// Recovery.
    /// </summary>
    Recovery,

    /// <summary>
    /// RestoreExternalBackup.
    /// </summary>
    RestoreExternalBackup,

    /// <summary>
    /// RestoreExternalBackupSecondary.
    /// </summary>
    RestoreExternalBackupSecondary,

    /// <summary>
    /// RestoreLongTermRetentionBackup.
    /// </summary>
    RestoreLongTermRetentionBackup,

    /// <summary>
    /// OnlineSecondary.
    /// </summary>
    OnlineSecondary,
}
