// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;

namespace Azure.Provisioning.Sql;

/// <summary>
/// Server info for the server trust group.
/// </summary>
public partial class ServerTrustGroupServerInfo : ProvisionableConstruct
{
    /// <summary>
    /// Server Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> ServerId 
    {
        get { Initialize(); return _serverId!; }
        set { Initialize(); _serverId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _serverId;

    /// <summary>
    /// Creates a new ServerTrustGroupServerInfo.
    /// </summary>
    public ServerTrustGroupServerInfo()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ServerTrustGroupServerInfo.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _serverId = DefineProperty<ResourceIdentifier>("ServerId", ["serverId"]);
    }
}
