// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// Properties of a active directory administrator.
/// </summary>
public partial class ServerExternalAdministrator : ProvisionableConstruct
{
    /// <summary>
    /// Type of the sever administrator.
    /// </summary>
    public BicepValue<SqlAdministratorType> AdministratorType 
    {
        get { Initialize(); return _administratorType!; }
        set { Initialize(); _administratorType!.Assign(value); }
    }
    private BicepValue<SqlAdministratorType>? _administratorType;

    /// <summary>
    /// Principal Type of the sever administrator.
    /// </summary>
    public BicepValue<SqlServerPrincipalType> PrincipalType 
    {
        get { Initialize(); return _principalType!; }
        set { Initialize(); _principalType!.Assign(value); }
    }
    private BicepValue<SqlServerPrincipalType>? _principalType;

    /// <summary>
    /// Login name of the server administrator.
    /// </summary>
    public BicepValue<string> Login 
    {
        get { Initialize(); return _login!; }
        set { Initialize(); _login!.Assign(value); }
    }
    private BicepValue<string>? _login;

    /// <summary>
    /// SID (object ID) of the server administrator.
    /// </summary>
    public BicepValue<Guid> Sid 
    {
        get { Initialize(); return _sid!; }
        set { Initialize(); _sid!.Assign(value); }
    }
    private BicepValue<Guid>? _sid;

    /// <summary>
    /// Tenant ID of the administrator.
    /// </summary>
    public BicepValue<Guid> TenantId 
    {
        get { Initialize(); return _tenantId!; }
        set { Initialize(); _tenantId!.Assign(value); }
    }
    private BicepValue<Guid>? _tenantId;

    /// <summary>
    /// Azure Active Directory only Authentication enabled.
    /// </summary>
    public BicepValue<bool> IsAzureADOnlyAuthenticationEnabled 
    {
        get { Initialize(); return _isAzureADOnlyAuthenticationEnabled!; }
        set { Initialize(); _isAzureADOnlyAuthenticationEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isAzureADOnlyAuthenticationEnabled;

    /// <summary>
    /// Creates a new ServerExternalAdministrator.
    /// </summary>
    public ServerExternalAdministrator()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ServerExternalAdministrator.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _administratorType = DefineProperty<SqlAdministratorType>("AdministratorType", ["administratorType"]);
        _principalType = DefineProperty<SqlServerPrincipalType>("PrincipalType", ["principalType"]);
        _login = DefineProperty<string>("Login", ["login"]);
        _sid = DefineProperty<Guid>("Sid", ["sid"]);
        _tenantId = DefineProperty<Guid>("TenantId", ["tenantId"]);
        _isAzureADOnlyAuthenticationEnabled = DefineProperty<bool>("IsAzureADOnlyAuthenticationEnabled", ["azureADOnlyAuthentication"]);
    }
}
