// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;

namespace Azure.Provisioning.Sql;

/// <summary>
/// Partner region information for the failover group.
/// </summary>
public partial class PartnerRegionInfo : ProvisionableConstruct
{
    /// <summary>
    /// Geo location of the partner managed instances.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// Replication role of the partner managed instances.
    /// </summary>
    public BicepValue<InstanceFailoverGroupReplicationRole> ReplicationRole 
    {
        get { Initialize(); return _replicationRole!; }
    }
    private BicepValue<InstanceFailoverGroupReplicationRole>? _replicationRole;

    /// <summary>
    /// Creates a new PartnerRegionInfo.
    /// </summary>
    public PartnerRegionInfo()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of PartnerRegionInfo.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _location = DefineProperty<AzureLocation>("Location", ["location"]);
        _replicationRole = DefineProperty<InstanceFailoverGroupReplicationRole>("ReplicationRole", ["replicationRole"], isOutput: true);
    }
}
