// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// A private endpoint connection under a managed instance.
/// </summary>
public partial class ManagedInstancePecProperty : ProvisionableConstruct
{
    /// <summary>
    /// Resource ID.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Private endpoint connection properties.
    /// </summary>
    public ManagedInstancePrivateEndpointConnectionProperties Properties 
    {
        get { Initialize(); return _properties!; }
    }
    private ManagedInstancePrivateEndpointConnectionProperties? _properties;

    /// <summary>
    /// Creates a new ManagedInstancePecProperty.
    /// </summary>
    public ManagedInstancePecProperty()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ManagedInstancePecProperty.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _properties = DefineModelProperty<ManagedInstancePrivateEndpointConnectionProperties>("Properties", ["properties"], isOutput: true);
    }
}
