// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;

namespace Azure.Provisioning.Sql;

/// <summary>
/// Pairs of Managed Instances in the failover group.
/// </summary>
public partial class ManagedInstancePairInfo : ProvisionableConstruct
{
    /// <summary>
    /// Id of Primary Managed Instance in pair.
    /// </summary>
    public BicepValue<ResourceIdentifier> PrimaryManagedInstanceId 
    {
        get { Initialize(); return _primaryManagedInstanceId!; }
        set { Initialize(); _primaryManagedInstanceId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _primaryManagedInstanceId;

    /// <summary>
    /// Id of Partner Managed Instance in pair.
    /// </summary>
    public BicepValue<ResourceIdentifier> PartnerManagedInstanceId 
    {
        get { Initialize(); return _partnerManagedInstanceId!; }
        set { Initialize(); _partnerManagedInstanceId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _partnerManagedInstanceId;

    /// <summary>
    /// Creates a new ManagedInstancePairInfo.
    /// </summary>
    public ManagedInstancePairInfo()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ManagedInstancePairInfo.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _primaryManagedInstanceId = DefineProperty<ResourceIdentifier>("PrimaryManagedInstanceId", ["primaryManagedInstanceId"]);
        _partnerManagedInstanceId = DefineProperty<ResourceIdentifier>("PartnerManagedInstanceId", ["partnerManagedInstanceId"]);
    }
}
