// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// The Transaction Manager Communication Settings of managed instance DTC.
/// </summary>
public partial class ManagedInstanceDtcTransactionManagerCommunicationSettings : ProvisionableConstruct
{
    /// <summary>
    /// Allow Inbound traffic to managed instance DTC.
    /// </summary>
    public BicepValue<bool> AllowInboundEnabled 
    {
        get { Initialize(); return _allowInboundEnabled!; }
        set { Initialize(); _allowInboundEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _allowInboundEnabled;

    /// <summary>
    /// Allow Outbound traffic of managed instance DTC.
    /// </summary>
    public BicepValue<bool> AllowOutboundEnabled 
    {
        get { Initialize(); return _allowOutboundEnabled!; }
        set { Initialize(); _allowOutboundEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _allowOutboundEnabled;

    /// <summary>
    /// Authentication type of managed instance DTC.
    /// </summary>
    public BicepValue<string> Authentication 
    {
        get { Initialize(); return _authentication!; }
        set { Initialize(); _authentication!.Assign(value); }
    }
    private BicepValue<string>? _authentication;

    /// <summary>
    /// Creates a new ManagedInstanceDtcTransactionManagerCommunicationSettings.
    /// </summary>
    public ManagedInstanceDtcTransactionManagerCommunicationSettings()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ManagedInstanceDtcTransactionManagerCommunicationSettings.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _allowInboundEnabled = DefineProperty<bool>("AllowInboundEnabled", ["allowInboundEnabled"]);
        _allowOutboundEnabled = DefineProperty<bool>("AllowOutboundEnabled", ["allowOutboundEnabled"]);
        _authentication = DefineProperty<string>("Authentication", ["authentication"]);
    }
}
